/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BSONBinaryWriter;
import com.mongodb.BaseWriteCommandMessage;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.MessageSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import java.util.List;
import org.bson.io.OutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InsertCommandMessage
extends BaseWriteCommandMessage {
    private final List<DBObject> documents;
    private final DBEncoder encoder;

    public InsertCommandMessage(MongoNamespace namespace, WriteConcern writeConcern, List<DBObject> documents, DBEncoder commandEncoder, DBEncoder encoder, MessageSettings settings) {
        super(namespace, writeConcern, commandEncoder, settings);
        this.documents = documents;
        this.encoder = encoder;
    }

    @Override
    protected String getCommandName() {
        return "insert";
    }

    @Override
    protected InsertCommandMessage writeTheWrites(OutputBuffer buffer, int commandStartPosition, BSONBinaryWriter writer) {
        InsertCommandMessage nextMessage = null;
        writer.writeStartArray("documents");
        writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
        for (int i = 0; i < this.documents.size(); ++i) {
            writer.mark();
            writer.encodeDocument(this.encoder, this.documents.get(i));
            if (!this.maximumCommandDocumentSizeExceeded(buffer, commandStartPosition)) continue;
            writer.reset();
            nextMessage = new InsertCommandMessage(this.getWriteNamespace(), this.getWriteConcern(), this.documents.subList(i, this.documents.size()), this.getCommandEncoder(), this.encoder, this.getSettings());
            break;
        }
        writer.popMaxDocumentSize();
        writer.writeEndArray();
        return nextMessage;
    }

    @Override
    public int getItemCount() {
        return this.documents.size();
    }
}

