/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.io.Bits;

class Response {
    final DBCollection _collection;
    final InputStream _raw;
    final MyInputStream _user;
    final BSONDecoder _decoder;
    final int _len;
    final int _id;
    final int _responseTo;
    final int _operation;
    final int _flags;
    final long _cursor;
    final int _startingFrom;
    final int _num;
    private DBObject _peek;
    private int _readSoFar;
    private List<DoneHook> _hooks = new LinkedList<DoneHook>();
    static ThreadLocal<BSONDecoder> TL = new ThreadLocal<BSONDecoder>(){

        @Override
        protected BSONDecoder initialValue() {
            return new BSONDecoder();
        }
    };

    Response(DBCollection collection, InputStream in) throws IOException {
        this._collection = collection;
        this._raw = in;
        byte[] b = new byte[16];
        for (int x = 0; x < b.length; x += in.read(b, x, b.length - x)) {
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        this._len = Bits.readInt(bin);
        this._id = Bits.readInt(bin);
        this._responseTo = Bits.readInt(bin);
        this._operation = Bits.readInt(bin);
        if (this._len > 0xC00000) {
            throw new IllegalArgumentException("response too long: " + this._len);
        }
        this._user = new MyInputStream(in, this._len - 16);
        this._flags = Bits.readInt(this._user);
        this._cursor = Bits.readLong(this._user);
        this._startingFrom = Bits.readInt(this._user);
        this._num = Bits.readInt(this._user);
        this._readSoFar = 0;
        this._decoder = TL.get();
    }

    void addHook(DoneHook h) {
        this._hooks.add(h);
    }

    boolean more() {
        return this._peek != null || this._readSoFar < this._num;
    }

    DBObject peek() {
        if (this._peek == null && this.more()) {
            this._peek = this.next();
        }
        return this._peek;
    }

    DBObject next() {
        if (this._peek != null) {
            DBObject foo = this._peek;
            this._peek = null;
            return foo;
        }
        if (this._readSoFar >= this._num) {
            throw new IllegalStateException("already finished");
        }
        DBCallback c = DBCallback.FACTORY.create(this._collection);
        try {
            this._decoder.decode(this._user, (BSONCallback)c);
        }
        catch (IOException ioe) {
            for (DoneHook h : this._hooks) {
                h.error(ioe);
            }
            this._hooks.clear();
            throw new MongoException.Network("can't read response", ioe);
        }
        ++this._readSoFar;
        return c.dbget();
    }

    public String toString() {
        return "flags:" + this._flags + " _cursor:" + this._cursor + " _startingFrom:" + this._startingFrom + " _num:" + this._num;
    }

    static interface DoneHook {
        public void done();

        public void error(IOException var1);
    }

    class MyInputStream
    extends InputStream {
        final InputStream _in;
        private int _toGo;

        MyInputStream(InputStream in, int max) {
            this._in = in;
            this._toGo = max;
        }

        public int available() throws IOException {
            return this._in.available();
        }

        public int read() throws IOException {
            if (this._toGo <= 0) {
                for (DoneHook h : Response.this._hooks) {
                    h.done();
                }
                Response.this._hooks.clear();
                return -1;
            }
            int val = this._in.read();
            --this._toGo;
            return val;
        }

        public void close() {
            throw new RuntimeException("can't close thos");
        }
    }
}

