/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBSONCallback
implements BSONCallback {
    private Object _root;
    private final LinkedList<BSONObject> _stack = new LinkedList();
    private final LinkedList<String> _nameStack = new LinkedList();

    public BasicBSONCallback() {
        this.reset();
    }

    public BSONObject create() {
        return new BasicBSONObject();
    }

    public BSONObject create(boolean array, List<String> path) {
        if (array) {
            return new BasicBSONList();
        }
        return new BasicBSONObject();
    }

    @Override
    public void objectStart() {
        if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        this.objectStart(false);
    }

    public void objectStart(boolean array) {
        this._root = this.create(array, null);
        this._stack.add((BSONObject)this._root);
    }

    @Override
    public void objectStart(String name) {
        this.objectStart(false, name);
    }

    public void objectStart(boolean array, String name) {
        this._nameStack.addLast(name);
        BSONObject o = this.create(array, this._nameStack);
        this._stack.getLast().put(name, o);
        this._stack.addLast(o);
    }

    @Override
    public Object objectDone() {
        BSONObject o = this._stack.removeLast();
        if (this._nameStack.size() > 0) {
            this._nameStack.removeLast();
        } else if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        return (BSONObject)BSON.applyDecodingHooks(o);
    }

    @Override
    public void arrayStart() {
        this.objectStart(true);
    }

    @Override
    public void arrayStart(String name) {
        this.objectStart(true, name);
    }

    @Override
    public Object arrayDone() {
        return this.objectDone();
    }

    @Override
    public void gotNull(String name) {
        this.cur().put(name, null);
    }

    @Override
    public void gotUndefined(String name) {
    }

    @Override
    public void gotMinKey(String name) {
        this.cur().put(name, "MinKey");
    }

    @Override
    public void gotMaxKey(String name) {
        this.cur().put(name, "MaxKey");
    }

    @Override
    public void gotBoolean(String name, boolean v) {
        this._put(name, v);
    }

    @Override
    public void gotDouble(String name, double v) {
        this._put(name, v);
    }

    @Override
    public void gotInt(String name, int v) {
        this._put(name, v);
    }

    @Override
    public void gotLong(String name, long v) {
        this._put(name, v);
    }

    @Override
    public void gotDate(String name, long millis) {
        this._put(name, new Date(millis));
    }

    @Override
    public void gotRegex(String name, String pattern, String flags) {
        this._put(name, Pattern.compile(pattern, BSON.regexFlags(flags)));
    }

    @Override
    public void gotString(String name, String v) {
        this._put(name, v);
    }

    @Override
    public void gotSymbol(String name, String v) {
        this._put(name, v);
    }

    @Override
    public void gotTimestamp(String name, int time, int inc) {
        this._put(name, new BSONTimestamp(time, inc));
    }

    @Override
    public void gotObjectId(String name, ObjectId id) {
        this._put(name, id);
    }

    @Override
    public void gotDBRef(String name, String ns, ObjectId id) {
        this._put(name, new BasicBSONObject("$ns", ns).append("$id", id));
    }

    @Override
    public void gotBinaryArray(String name, byte[] b) {
        this._put(name, b);
    }

    @Override
    public void gotBinary(String name, byte type, byte[] data) {
        this._put(name, new Binary(type, data));
    }

    @Override
    public void gotUUID(String name, long part1, long part2) {
        this._put(name, new UUID(part1, part2));
    }

    protected void _put(String name, Object o) {
        this.cur().put(name, BSON.applyDecodingHooks(o));
    }

    protected BSONObject cur() {
        return this._stack.getLast();
    }

    public Object get() {
        return this._root;
    }

    protected void setRoot(Object o) {
        this._root = o;
    }

    protected boolean isStackEmpty() {
        return this._stack.size() < 1;
    }

    public void reset() {
        this._root = null;
        this._stack.clear();
        this._nameStack.clear();
    }
}

