/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBPort;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.util.SimplePool;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBPortPool
extends SimplePool<DBPort> {
    final MongoOptions _options;
    private final Semaphore _waitingSem;
    final InetSocketAddress _addr;
    boolean _everWorked = false;

    DBPortPool(InetSocketAddress addr, MongoOptions options) {
        super("DBPortPool-" + addr.toString(), options.connectionsPerHost, options.connectionsPerHost);
        this._options = options;
        this._addr = addr;
        this._waitingSem = new Semaphore(this._options.connectionsPerHost * this._options.threadsAllowedToBlockForConnectionMultiplier);
    }

    protected long memSize(DBPort p) {
        return 0L;
    }

    @Override
    protected int pick(int iThink, boolean couldCreate) {
        int id = Thread.currentThread().hashCode();
        int s = this._availSafe.size();
        for (int i = 0; i < s; ++i) {
            DBPort p = (DBPort)this._availSafe.get(i);
            if (p._lastThread != id) continue;
            return i;
        }
        if (couldCreate) {
            return -1;
        }
        return iThink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBPort get() {
        DBPort port = null;
        if (!this._waitingSem.tryAcquire()) {
            throw new SemaphoresOut();
        }
        try {
            port = (DBPort)this.get(this._options.maxWaitTime);
        }
        finally {
            this._waitingSem.release();
        }
        if (port == null) {
            throw new ConnectionWaitTimeOut(this._options.maxWaitTime);
        }
        port._lastThread = Thread.currentThread().hashCode();
        return port;
    }

    void gotError(Exception e) {
        if (e instanceof ClosedByInterruptException || e instanceof InterruptedException) {
            return;
        }
        if (e instanceof SocketTimeoutException && this._options.socketTimeout > 0) {
            return;
        }
        Bytes.LOGGER.log(Level.INFO, "emptying DBPortPool b/c of error", e);
        this.clear();
    }

    void close() {
        this.clear();
    }

    @Override
    public boolean ok(DBPort t) {
        return this._addr.equals(t._addr);
    }

    @Override
    protected DBPort createNew() throws MongoInternalException {
        try {
            return new DBPort(this._addr, this, this._options);
        }
        catch (IOException ioe) {
            throw new MongoInternalException("can't create port to:" + this._addr, ioe);
        }
    }

    public static class ConnectionWaitTimeOut
    extends NoMoreConnection {
        ConnectionWaitTimeOut(int timeout) {
            super("Connection wait timeout after " + timeout + " ms");
        }
    }

    public static class SemaphoresOut
    extends NoMoreConnection {
        SemaphoresOut() {
            super("Out of semaphores to get db connection");
        }
    }

    public static class NoMoreConnection
    extends MongoInternalException {
        NoMoreConnection(String msg) {
            super(msg);
        }
    }

    static class Holder {
        final MongoOptions _options;
        final Map<InetSocketAddress, DBPortPool> _pools = Collections.synchronizedMap(new HashMap());
        final MBeanServer _server = ManagementFactory.getPlatformMBeanServer();

        Holder(MongoOptions options) {
            this._options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DBPortPool get(InetSocketAddress addr) {
            DBPortPool p = this._pools.get(addr);
            if (p != null) {
                return p;
            }
            Map<InetSocketAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                p = this._pools.get(addr);
                if (p != null) {
                    return p;
                }
                p = new DBPortPool(addr, this._options);
                this._pools.put(addr, p);
                String name = "com.mongodb:type=ConnectionPool,host=" + addr.toString().replace(':', '_');
                try {
                    ObjectName on = new ObjectName(name);
                    if (this._server.isRegistered(on)) {
                        this._server.unregisterMBean(on);
                        Bytes.LOGGER.log(Level.INFO, "multiple Mongo instances for same host, jmx numbers might be off");
                    }
                    this._server.registerMBean(p, on);
                }
                catch (JMException e) {
                    Bytes.LOGGER.log(Level.WARNING, "jmx registration error, continuing", e);
                }
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Map<InetSocketAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                for (DBPortPool p : this._pools.values()) {
                    p.close();
                }
            }
        }
    }
}

