/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.bson.types.ObjectId;

public class DBApiLayer
extends DB {
    static final boolean D = Boolean.getBoolean("DEBUG.DB");
    static final int NUM_CURSORS_BEFORE_KILL = 100;
    static final boolean SHOW = Boolean.getBoolean("DB.SHOW");
    final String _root;
    final String _rootPlusDot;
    final DBConnector _connector;
    final Map<String, MyCollection> _collections = Collections.synchronizedMap(new HashMap());
    final Map<String, DBApiLayer> _sisters = Collections.synchronizedMap(new HashMap());
    List<Long> _deadCursorIds = new Vector<Long>();
    static final List<DBObject> EMPTY = Collections.unmodifiableList(new LinkedList());

    protected DBApiLayer(String root, DBConnector connector) {
        super(root);
        this._root = root;
        this._rootPlusDot = this._root + ".";
        this._connector = connector;
    }

    public void requestStart() {
        this._connector.requestStart();
    }

    public void requestDone() {
        this._connector.requestDone();
    }

    public void requestEnsureConnection() {
        this._connector.requestEnsureConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyCollection doGetCollection(String name) {
        MyCollection c = this._collections.get(name);
        if (c != null) {
            return c;
        }
        Map<String, MyCollection> map = this._collections;
        synchronized (map) {
            c = this._collections.get(name);
            if (c != null) {
                return c;
            }
            c = new MyCollection(name);
            this._collections.put(name, c);
        }
        return c;
    }

    String _removeRoot(String ns) {
        if (!ns.startsWith(this._rootPlusDot)) {
            return ns;
        }
        return ns.substring(this._root.length() + 1);
    }

    public DBCollection getCollectionFromFull(String fullNameSpace) {
        if (fullNameSpace.indexOf(".") < 0) {
            return this.doGetCollection(fullNameSpace);
        }
        int idx = fullNameSpace.indexOf(".");
        String root = fullNameSpace.substring(0, idx);
        String table = fullNameSpace.substring(idx + 1);
        if (this._root.equals(root)) {
            return this.doGetCollection(table);
        }
        return this.getSisterDB(root).getCollection(table);
    }

    public DB getSisterDB(String dbName) {
        return new DBApiLayer(dbName, this._connector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Result
    implements Iterator<DBObject> {
        Response _curResult;
        Iterator<DBObject> _cur;
        int _numToReturn;
        final MyCollection _collection;
        final int _options;
        private long _totalBytes = 0L;
        private int _numGetMores = 0;
        private List<Integer> _sizes = new ArrayList<Integer>();

        Result(MyCollection coll, Response res, int numToReturn, int options) {
            this.init(res);
            this._collection = coll;
            this._numToReturn = numToReturn;
            this._options = options;
        }

        private void init(Response res) {
            this._totalBytes += (long)res._len;
            this._curResult = res;
            this._cur = res.iterator();
            this._sizes.add(res.size());
        }

        @Override
        public DBObject next() {
            if (this._cur.hasNext()) {
                return this._cur.next();
            }
            if (!this._curResult.hasGetMore(this._options)) {
                throw new RuntimeException("no more");
            }
            this._advance();
            return this.next();
        }

        @Override
        public boolean hasNext() {
            if (this._cur.hasNext()) {
                return true;
            }
            if (!this._curResult.hasGetMore(this._options)) {
                return false;
            }
            this._advance();
            return this.hasNext();
        }

        private void _advance() {
            if (this._curResult.cursor() <= 0L) {
                throw new RuntimeException("can't advance a cursor <= 0");
            }
            OutMessage m = OutMessage.get(2005);
            m.writeInt(0);
            m.writeCString(this._collection._fullNameSpace);
            m.writeInt(this._numToReturn);
            m.writeLong(this._curResult.cursor());
            try {
                Response res = DBApiLayer.this._connector.call(DBApiLayer.this, this._collection, m);
                ++this._numGetMores;
                this.init(res);
            }
            catch (MongoException me) {
                throw new MongoInternalException("can't do getmore", me);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("can't remove this way");
        }

        public int getNumberToReturn() {
            return this._numToReturn;
        }

        public void setNumberToReturn(int num) {
            this._numToReturn = num;
        }

        public String toString() {
            return "DBCursor";
        }

        protected void finalize() throws Throwable {
            if (this._curResult != null && this._curResult.cursor() > 0L) {
                DBApiLayer.this._deadCursorIds.add(this._curResult.cursor());
            }
            super.finalize();
        }

        public long totalBytes() {
            return this._totalBytes;
        }

        int numGetMores() {
            return this._numGetMores;
        }

        List<Integer> getSizes() {
            return Collections.unmodifiableList(this._sizes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyCollection
    extends DBCollection {
        final String _fullNameSpace;

        MyCollection(String name) {
            super(DBApiLayer.this, name);
            this._fullNameSpace = DBApiLayer.this._root + "." + name;
        }

        @Override
        public void doapply(DBObject o) {
        }

        @Override
        public void insert(DBObject o) throws MongoException {
            this.insert(new DBObject[]{o});
        }

        @Override
        public void insert(DBObject[] arr) throws MongoException {
            this.insert(arr, true);
        }

        @Override
        public void insert(List<DBObject> list) throws MongoException {
            this.insert(list.toArray(new DBObject[list.size()]), true);
        }

        protected void insert(DBObject obj, boolean shouldApply) throws MongoException {
            this.insert(new DBObject[]{obj}, shouldApply);
        }

        protected void insert(DBObject[] arr, boolean shouldApply) throws MongoException {
            if (SHOW) {
                for (DBObject o : arr) {
                    System.out.println("save:  " + this._fullNameSpace + " " + JSON.serialize(o));
                }
            }
            if (shouldApply) {
                for (int i = 0; i < arr.length; ++i) {
                    DBObject o = arr[i];
                    this.apply(o);
                    Object id = o.get("_id");
                    if (!(id instanceof ObjectId)) continue;
                    ((ObjectId)id).notNew();
                }
            }
            int cur = 0;
            while (cur < arr.length) {
                OutMessage om = OutMessage.get(2002);
                om.writeInt(0);
                om.writeCString(this._fullNameSpace);
                while (cur < arr.length) {
                    DBObject o = arr[cur];
                    int sz = om.putObject(o);
                    if (sz > 0x400000) {
                        throw new IllegalArgumentException("object too big: " + sz);
                    }
                    if (om.size() > 0x400000) {
                        ++cur;
                        break;
                    }
                    ++cur;
                }
                DBApiLayer.this._connector.say(this._db, om, this.getWriteConcern());
            }
        }

        @Override
        public void remove(DBObject o) throws MongoException {
            if (SHOW) {
                System.out.println("remove: " + this._fullNameSpace + " " + JSON.serialize(o));
            }
            OutMessage om = OutMessage.get(2006);
            om.writeInt(0);
            om.writeCString(this._fullNameSpace);
            Set<String> keys = o.keySet();
            if (keys.size() == 1 && ((String)keys.iterator().next()).equals("_id") && o.get((String)keys.iterator().next()) instanceof ObjectId) {
                om.writeInt(1);
            } else {
                om.writeInt(0);
            }
            om.putObject(o);
            DBApiLayer.this._connector.say(this._db, om, this.getWriteConcern());
        }

        void _cleanCursors() throws MongoException {
            if (DBApiLayer.this._deadCursorIds.size() == 0) {
                return;
            }
            if (DBApiLayer.this._deadCursorIds.size() % 20 != 0 && DBApiLayer.this._deadCursorIds.size() < 100) {
                return;
            }
            List<Long> l = DBApiLayer.this._deadCursorIds;
            DBApiLayer.this._deadCursorIds = new Vector<Long>();
            Bytes.LOGGER.info("trying to kill cursors : " + l.size());
            try {
                this.killCursors(l);
            }
            catch (Throwable t) {
                Bytes.LOGGER.log(Level.WARNING, "can't clean cursors", t);
                DBApiLayer.this._deadCursorIds.addAll(l);
            }
        }

        void killCursors(List<Long> all) throws MongoException {
            if (all == null || all.size() == 0) {
                return;
            }
            OutMessage om = OutMessage.get(2007);
            om.writeInt(0);
            om.writeInt(all.size());
            for (Long l : all) {
                om.writeLong(l);
            }
            DBApiLayer.this._connector.say(this._db, om, DB.WriteConcern.NONE);
        }

        @Override
        Iterator<DBObject> __find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int options) throws MongoException {
            DBObject foo;
            Object err;
            Response res;
            if (ref == null) {
                ref = new BasicDBObject();
            }
            if (SHOW) {
                System.out.println("find: " + this._fullNameSpace + " " + JSON.serialize(ref));
            }
            this._cleanCursors();
            OutMessage query = OutMessage.get(2004);
            query.writeInt(options);
            query.writeCString(this._fullNameSpace);
            query.writeInt(numToSkip);
            query.writeInt(batchSize);
            query.putObject(ref);
            if (fields != null) {
                query.putObject(fields);
            }
            if ((res = DBApiLayer.this._connector.call(this._db, this, query, 2)).size() == 0) {
                return null;
            }
            if (res.size() == 1 && (err = (foo = res.get(0)).get("$err")) != null) {
                throw new MongoException(foo);
            }
            return new Result(this, res, batchSize, options);
        }

        @Override
        public void update(DBObject query, DBObject o, boolean upsert, boolean multi) throws MongoException {
            if (SHOW) {
                System.out.println("update: " + this._fullNameSpace + " " + JSON.serialize(query));
            }
            OutMessage om = OutMessage.get(2001);
            om.writeInt(0);
            om.writeCString(this._fullNameSpace);
            int flags = 0;
            if (upsert) {
                flags |= 1;
            }
            if (multi) {
                flags |= 2;
            }
            om.writeInt(flags);
            om.putObject(query);
            om.putObject(o);
            DBApiLayer.this._connector.say(this._db, om, this.getWriteConcern());
        }

        @Override
        protected void createIndex(DBObject keys, DBObject options) throws MongoException {
            BasicDBObject full = new BasicDBObject();
            for (String k : options.keySet()) {
                full.put(k, options.get(k));
            }
            full.put("key", (Object)keys);
            DBApiLayer.this.doGetCollection("system.indexes").insert(full, false);
        }
    }
}

