/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ServerError;

public class CommandResult
extends BasicDBObject {
    DBObject _cmd;

    CommandResult() {
    }

    public boolean ok() {
        Object o = this.get("ok");
        if (o == null) {
            throw new IllegalArgumentException("'ok' should never be null...");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() == 1;
        }
        throw new IllegalArgumentException("can't figure out what to do with: " + o.getClass().getName());
    }

    public String getErrorMessage() {
        Object foo = this.get("errmsg");
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public MongoException getException() {
        String cmdName = this._cmd.keySet().iterator().next();
        StringBuilder buf = new StringBuilder("command failed [");
        buf.append("command failed [").append(cmdName).append("] ");
        buf.append(this.toString());
        return new CommandFailure(this, buf.toString());
    }

    public void throwOnError() throws MongoException {
        if (!this.ok()) {
            throw this.getException();
        }
    }

    static class CommandFailure
    extends MongoException {
        CommandFailure(CommandResult res, String msg) {
            super(ServerError._getCode(res), msg);
        }
    }
}

