/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.Float32Vector;
import org.bson.Int8Vector;
import org.bson.PackedBitVector;
import org.bson.assertions.Assertions;

public abstract class Vector {
    private final DataType dataType;

    Vector(DataType dataType) {
        this.dataType = dataType;
    }

    public static PackedBitVector packedBitVector(byte[] data, byte padding) {
        Assertions.notNull("data", data);
        Assertions.isTrueArgument("Padding must be between 0 and 7 bits. Provided padding: " + padding, padding >= 0 && padding <= 7);
        Assertions.isTrueArgument("Padding must be 0 if vector is empty. Provided padding: " + padding, padding == 0 || data.length > 0);
        return new PackedBitVector(data, padding);
    }

    public static Int8Vector int8Vector(byte[] data) {
        Assertions.notNull("data", data);
        return new Int8Vector(data);
    }

    public static Float32Vector floatVector(float[] data) {
        Assertions.notNull("data", data);
        return new Float32Vector(data);
    }

    public PackedBitVector asPackedBitVector() {
        this.ensureType(DataType.PACKED_BIT);
        return (PackedBitVector)this;
    }

    public Int8Vector asInt8Vector() {
        this.ensureType(DataType.INT8);
        return (Int8Vector)this;
    }

    public Float32Vector asFloat32Vector() {
        this.ensureType(DataType.FLOAT32);
        return (Float32Vector)this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void ensureType(DataType expected) {
        if (this.dataType != expected) {
            throw new IllegalStateException("Expected vector data type " + (Object)((Object)expected) + ", but found " + (Object)((Object)this.dataType));
        }
    }

    public static enum DataType {
        INT8(3),
        FLOAT32(39),
        PACKED_BIT(16);

        private final byte value;

        private DataType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

