/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Arrays;
import java.util.Objects;
import org.bson.Vector;
import org.bson.assertions.Assertions;

public final class PackedBitVector
extends Vector {
    private final byte padding;
    private final byte[] data;

    PackedBitVector(byte[] data, byte padding) {
        super(Vector.DataType.PACKED_BIT);
        this.data = Assertions.assertNotNull(data);
        this.padding = padding;
    }

    public byte[] getData() {
        return Assertions.assertNotNull(this.data);
    }

    public byte getPadding() {
        return this.padding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackedBitVector that = (PackedBitVector)o;
        return this.padding == that.padding && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.padding, Arrays.hashCode(this.data));
    }

    public String toString() {
        return "PackedBitVector{padding=" + this.padding + ", data=" + Arrays.toString(this.data) + ", dataType=" + (Object)((Object)this.getDataType()) + '}';
    }
}

