/*
 * Decompiled with CFR 0.152.
 */
package org.bson.json;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.bson.AbstractBsonReader;
import org.bson.BSONException;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonUndefined;
import org.bson.json.JsonParseException;
import org.bson.json.JsonScanner;
import org.bson.json.JsonToken;
import org.bson.json.JsonTokenType;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class JsonReader
extends AbstractBsonReader {
    private final JsonScanner scanner;
    private JsonToken pushedToken;
    private Object currentValue;
    private Mark mark;

    public JsonReader(String json) {
        this.scanner = new JsonScanner(json);
        this.setContext(new Context(null, BsonContextType.TOP_LEVEL));
    }

    @Override
    protected BsonBinary doReadBinaryData() {
        return (BsonBinary)this.currentValue;
    }

    @Override
    protected byte doPeekBinarySubType() {
        return this.doReadBinaryData().getType();
    }

    @Override
    protected boolean doReadBoolean() {
        return (Boolean)this.currentValue;
    }

    @Override
    public BsonType readBsonType() {
        JsonToken commaToken;
        if (this.isClosed()) {
            throw new IllegalStateException("This instance has been closed");
        }
        if (this.getState() == AbstractBsonReader.State.INITIAL || this.getState() == AbstractBsonReader.State.DONE || this.getState() == AbstractBsonReader.State.SCOPE_DOCUMENT) {
            this.setState(AbstractBsonReader.State.TYPE);
        }
        if (this.getState() != AbstractBsonReader.State.TYPE) {
            this.throwInvalidState("readBSONType", AbstractBsonReader.State.TYPE);
        }
        if (this.getContext().getContextType() == BsonContextType.DOCUMENT) {
            JsonToken nameToken = this.popToken();
            switch (nameToken.getType()) {
                case STRING: 
                case UNQUOTED_STRING: {
                    this.setCurrentName(nameToken.getValue(String.class));
                    break;
                }
                case END_OBJECT: {
                    this.setState(AbstractBsonReader.State.END_OF_DOCUMENT);
                    return BsonType.END_OF_DOCUMENT;
                }
                default: {
                    throw new JsonParseException("JSON reader was expecting a name but found '%s'.", nameToken.getValue());
                }
            }
            JsonToken colonToken = this.popToken();
            if (colonToken.getType() != JsonTokenType.COLON) {
                throw new JsonParseException("JSON reader was expecting ':' but found '%s'.", colonToken.getValue());
            }
        }
        JsonToken token = this.popToken();
        if (this.getContext().getContextType() == BsonContextType.ARRAY && token.getType() == JsonTokenType.END_ARRAY) {
            this.setState(AbstractBsonReader.State.END_OF_ARRAY);
            return BsonType.END_OF_DOCUMENT;
        }
        boolean noValueFound = false;
        switch (token.getType()) {
            case BEGIN_ARRAY: {
                this.setCurrentBsonType(BsonType.ARRAY);
                break;
            }
            case BEGIN_OBJECT: {
                this.visitExtendedJSON();
                break;
            }
            case DOUBLE: {
                this.setCurrentBsonType(BsonType.DOUBLE);
                this.currentValue = token.getValue();
                break;
            }
            case END_OF_FILE: {
                this.setCurrentBsonType(BsonType.END_OF_DOCUMENT);
                break;
            }
            case INT32: {
                this.setCurrentBsonType(BsonType.INT32);
                this.currentValue = token.getValue();
                break;
            }
            case INT64: {
                this.setCurrentBsonType(BsonType.INT64);
                this.currentValue = token.getValue();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                this.currentValue = token.getValue();
                break;
            }
            case STRING: {
                this.setCurrentBsonType(BsonType.STRING);
                this.currentValue = token.getValue();
                break;
            }
            case UNQUOTED_STRING: {
                String value = token.getValue(String.class);
                if ("false".equals(value) || "true".equals(value)) {
                    this.setCurrentBsonType(BsonType.BOOLEAN);
                    this.currentValue = Boolean.parseBoolean(value);
                    break;
                }
                if ("Infinity".equals(value)) {
                    this.setCurrentBsonType(BsonType.DOUBLE);
                    this.currentValue = Double.POSITIVE_INFINITY;
                    break;
                }
                if ("NaN".equals(value)) {
                    this.setCurrentBsonType(BsonType.DOUBLE);
                    this.currentValue = Double.NaN;
                    break;
                }
                if ("null".equals(value)) {
                    this.setCurrentBsonType(BsonType.NULL);
                    break;
                }
                if ("undefined".equals(value)) {
                    this.setCurrentBsonType(BsonType.UNDEFINED);
                    break;
                }
                if ("BinData".equals(value)) {
                    this.setCurrentBsonType(BsonType.BINARY);
                    this.currentValue = this.visitBinDataConstructor();
                    break;
                }
                if ("Date".equals(value)) {
                    this.setCurrentBsonType(BsonType.DATE_TIME);
                    this.currentValue = this.visitDateTimeConstructor();
                    break;
                }
                if ("HexData".equals(value)) {
                    this.setCurrentBsonType(BsonType.BINARY);
                    this.currentValue = this.visitHexDataConstructor();
                    break;
                }
                if ("ISODate".equals(value)) {
                    this.setCurrentBsonType(BsonType.DATE_TIME);
                    this.currentValue = this.visitISODateTimeConstructor();
                    break;
                }
                if ("NumberLong".equals(value)) {
                    this.setCurrentBsonType(BsonType.INT64);
                    this.currentValue = this.visitNumberLongConstructor();
                    break;
                }
                if ("ObjectId".equals(value)) {
                    this.setCurrentBsonType(BsonType.OBJECT_ID);
                    this.currentValue = this.visitObjectIdConstructor();
                    break;
                }
                if ("Timestamp".equals(value)) {
                    this.setCurrentBsonType(BsonType.TIMESTAMP);
                    this.currentValue = this.visitTimestampConstructor();
                    break;
                }
                if ("RegExp".equals(value)) {
                    this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                    this.currentValue = this.visitRegularExpressionConstructor();
                    break;
                }
                if ("DBPointer".equals(value)) {
                    this.setCurrentBsonType(BsonType.DB_POINTER);
                    this.currentValue = this.visitDBPointerConstructor();
                    break;
                }
                if ("UUID".equals(value) || "GUID".equals(value) || "CSUUID".equals(value) || "CSGUID".equals(value) || "JUUID".equals(value) || "JGUID".equals(value) || "PYUUID".equals(value) || "PYGUID".equals(value)) {
                    this.setCurrentBsonType(BsonType.BINARY);
                    this.currentValue = this.visitUUIDConstructor(value);
                    break;
                }
                if ("new".equals(value)) {
                    this.visitNew();
                    break;
                }
                noValueFound = true;
                break;
            }
            default: {
                noValueFound = true;
            }
        }
        if (noValueFound) {
            throw new JsonParseException("JSON reader was expecting a value but found '%s'.", token.getValue());
        }
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (commaToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(commaToken);
        }
        switch (this.getContext().getContextType()) {
            default: {
                this.setState(AbstractBsonReader.State.NAME);
                break;
            }
            case ARRAY: 
            case JAVASCRIPT_WITH_SCOPE: 
            case TOP_LEVEL: {
                this.setState(AbstractBsonReader.State.VALUE);
            }
        }
        return this.getCurrentBsonType();
    }

    @Override
    protected long doReadDateTime() {
        return (Long)this.currentValue;
    }

    @Override
    protected double doReadDouble() {
        return (Double)this.currentValue;
    }

    @Override
    protected void doReadEndArray() {
        JsonToken commaToken;
        this.setContext(this.getContext().getParentContext());
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (commaToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(commaToken);
        }
    }

    private void setStateOnEnd() {
        switch (this.getContext().getContextType()) {
            case DOCUMENT: 
            case ARRAY: {
                this.setState(AbstractBsonReader.State.TYPE);
                break;
            }
            case TOP_LEVEL: {
                this.setState(AbstractBsonReader.State.DONE);
                break;
            }
            default: {
                throw new JsonParseException("Unexpected ContextType %s.", new Object[]{this.getContext().getContextType()});
            }
        }
    }

    @Override
    protected void doReadEndDocument() {
        JsonToken commaToken;
        this.setContext(this.getContext().getParentContext());
        if (this.getContext() != null && this.getContext().getContextType() == BsonContextType.SCOPE_DOCUMENT) {
            this.setContext(this.getContext().getParentContext());
            this.verifyToken("}");
        }
        if (this.getContext() == null) {
            throw new JsonParseException("Unexpected end of document.");
        }
        if ((this.getContext().getContextType() == BsonContextType.ARRAY || this.getContext().getContextType() == BsonContextType.DOCUMENT) && (commaToken = this.popToken()).getType() != JsonTokenType.COMMA) {
            this.pushToken(commaToken);
        }
    }

    @Override
    protected int doReadInt32() {
        return (Integer)this.currentValue;
    }

    @Override
    protected long doReadInt64() {
        return (Long)this.currentValue;
    }

    @Override
    protected String doReadJavaScript() {
        return (String)this.currentValue;
    }

    @Override
    protected String doReadJavaScriptWithScope() {
        return (String)this.currentValue;
    }

    @Override
    protected void doReadMaxKey() {
    }

    @Override
    protected void doReadMinKey() {
    }

    @Override
    protected void doReadNull() {
    }

    @Override
    protected ObjectId doReadObjectId() {
        return (ObjectId)this.currentValue;
    }

    @Override
    protected BsonRegularExpression doReadRegularExpression() {
        return (BsonRegularExpression)this.currentValue;
    }

    @Override
    protected BsonDbPointer doReadDBPointer() {
        return (BsonDbPointer)this.currentValue;
    }

    @Override
    protected void doReadStartArray() {
        this.setContext(new Context((AbstractBsonReader.Context)this.getContext(), BsonContextType.ARRAY));
    }

    @Override
    protected void doReadStartDocument() {
        this.setContext(new Context((AbstractBsonReader.Context)this.getContext(), BsonContextType.DOCUMENT));
    }

    @Override
    protected String doReadString() {
        return (String)this.currentValue;
    }

    @Override
    protected String doReadSymbol() {
        return (String)this.currentValue;
    }

    @Override
    protected BsonTimestamp doReadTimestamp() {
        return (BsonTimestamp)this.currentValue;
    }

    @Override
    protected void doReadUndefined() {
    }

    @Override
    protected void doSkipName() {
    }

    @Override
    protected void doSkipValue() {
        switch (this.getCurrentBsonType()) {
            case ARRAY: {
                this.readStartArray();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipValue();
                }
                this.readEndArray();
                break;
            }
            case BINARY: {
                this.readBinaryData();
                break;
            }
            case BOOLEAN: {
                this.readBoolean();
                break;
            }
            case DATE_TIME: {
                this.readDateTime();
                break;
            }
            case DOCUMENT: {
                this.readStartDocument();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipName();
                    this.skipValue();
                }
                this.readEndDocument();
                break;
            }
            case DOUBLE: {
                this.readDouble();
                break;
            }
            case INT32: {
                this.readInt32();
                break;
            }
            case INT64: {
                this.readInt64();
                break;
            }
            case JAVASCRIPT: {
                this.readJavaScript();
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.readJavaScriptWithScope();
                this.readStartDocument();
                while (this.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    this.skipName();
                    this.skipValue();
                }
                this.readEndDocument();
                break;
            }
            case MAX_KEY: {
                this.readMaxKey();
                break;
            }
            case MIN_KEY: {
                this.readMinKey();
                break;
            }
            case NULL: {
                this.readNull();
                break;
            }
            case OBJECT_ID: {
                this.readObjectId();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.readRegularExpression();
                break;
            }
            case STRING: {
                this.readString();
                break;
            }
            case SYMBOL: {
                this.readSymbol();
                break;
            }
            case TIMESTAMP: {
                this.readTimestamp();
                break;
            }
            case UNDEFINED: {
                this.readUndefined();
                break;
            }
        }
    }

    private JsonToken popToken() {
        if (this.pushedToken != null) {
            JsonToken token = this.pushedToken;
            this.pushedToken = null;
            return token;
        }
        return this.scanner.nextToken();
    }

    private void pushToken(JsonToken token) {
        if (this.pushedToken != null) {
            throw new BsonInvalidOperationException("There is already a pending token.");
        }
        this.pushedToken = token;
    }

    private void verifyToken(Object expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Can't be null");
        }
        JsonToken token = this.popToken();
        if (!expected.equals(token.getValue())) {
            throw new JsonParseException("JSON reader expected '%s' but found '%s'.", expected, token.getValue());
        }
    }

    private void verifyString(String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Can't be null");
        }
        JsonToken token = this.popToken();
        JsonTokenType type = token.getType();
        if (type != JsonTokenType.STRING && type != JsonTokenType.UNQUOTED_STRING && !expected.equals(token.getValue())) {
            throw new JsonParseException("JSON reader expected '%s' but found '%s'.", expected, token.getValue());
        }
    }

    private void visitNew() {
        JsonToken typeToken = this.popToken();
        if (typeToken.getType() != JsonTokenType.UNQUOTED_STRING) {
            throw new JsonParseException("JSON reader expected a type name but found '%s'.", typeToken.getValue());
        }
        String value = typeToken.getValue(String.class);
        if ("BinData".equals(value)) {
            this.currentValue = this.visitBinDataConstructor();
            this.setCurrentBsonType(BsonType.BINARY);
        } else if ("Date".equals(value)) {
            this.currentValue = this.visitDateTimeConstructor();
            this.setCurrentBsonType(BsonType.DATE_TIME);
        } else if ("HexData".equals(value)) {
            this.currentValue = this.visitHexDataConstructor();
            this.setCurrentBsonType(BsonType.BINARY);
        } else if ("ISODate".equals(value)) {
            this.currentValue = this.visitISODateTimeConstructor();
            this.setCurrentBsonType(BsonType.DATE_TIME);
        } else if ("NumberLong".equals(value)) {
            this.currentValue = this.visitNumberLongConstructor();
            this.setCurrentBsonType(BsonType.INT64);
        } else if ("ObjectId".equals(value)) {
            this.currentValue = this.visitObjectIdConstructor();
            this.setCurrentBsonType(BsonType.OBJECT_ID);
        } else if ("RegExp".equals(value)) {
            this.currentValue = this.visitRegularExpressionConstructor();
            this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
        } else if ("DBPointer".equals(value)) {
            this.currentValue = this.visitDBPointerConstructor();
            this.setCurrentBsonType(BsonType.DB_POINTER);
        } else if ("UUID".equals(value) || "GUID".equals(value) || "CSUUID".equals(value) || "CSGUID".equals(value) || "JUUID".equals(value) || "JGUID".equals(value) || "PYUUID".equals(value) || "PYGUID".equals(value)) {
            this.currentValue = this.visitUUIDConstructor(value);
            this.setCurrentBsonType(BsonType.BINARY);
        } else {
            throw new JsonParseException("JSON reader expected a type name but found '%s'.", value);
        }
    }

    private void visitExtendedJSON() {
        JsonToken nameToken = this.popToken();
        String value = nameToken.getValue(String.class);
        JsonTokenType type = nameToken.getType();
        if (type == JsonTokenType.STRING || type == JsonTokenType.UNQUOTED_STRING) {
            if ("$binary".equals(value)) {
                this.currentValue = this.visitBinDataExtendedJson();
                this.setCurrentBsonType(BsonType.BINARY);
                return;
            }
            if ("$code".equals(value)) {
                this.visitJavaScriptExtendedJson();
                return;
            }
            if ("$date".equals(value)) {
                this.currentValue = this.visitDateTimeExtendedJson();
                this.setCurrentBsonType(BsonType.DATE_TIME);
                return;
            }
            if ("$maxKey".equals(value)) {
                this.currentValue = this.visitMaxKeyExtendedJson();
                this.setCurrentBsonType(BsonType.MAX_KEY);
                return;
            }
            if ("$minKey".equals(value)) {
                this.currentValue = this.visitMinKeyExtendedJson();
                this.setCurrentBsonType(BsonType.MIN_KEY);
                return;
            }
            if ("$oid".equals(value)) {
                this.currentValue = this.visitObjectIdExtendedJson();
                this.setCurrentBsonType(BsonType.OBJECT_ID);
                return;
            }
            if ("$regex".equals(value)) {
                this.currentValue = this.visitRegularExpressionExtendedJson();
                this.setCurrentBsonType(BsonType.REGULAR_EXPRESSION);
                return;
            }
            if ("$symbol".equals(value)) {
                this.currentValue = this.visitSymbolExtendedJson();
                this.setCurrentBsonType(BsonType.SYMBOL);
                return;
            }
            if ("$timestamp".equals(value)) {
                this.currentValue = this.visitTimestampExtendedJson();
                this.setCurrentBsonType(BsonType.TIMESTAMP);
                return;
            }
            if ("$undefined".equals(value)) {
                this.currentValue = this.visitUndefinedExtendedJson();
                this.setCurrentBsonType(BsonType.UNDEFINED);
                return;
            }
            if ("$numberLong".equals(value)) {
                this.currentValue = this.visitNumberLongExtendedJson();
                this.setCurrentBsonType(BsonType.INT64);
                return;
            }
        }
        this.pushToken(nameToken);
        this.setCurrentBsonType(BsonType.DOCUMENT);
    }

    private BsonBinary visitBinDataConstructor() {
        this.verifyToken("(");
        JsonToken subTypeToken = this.popToken();
        if (subTypeToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected a binary subtype but found '%s'.", subTypeToken.getValue());
        }
        this.verifyToken(",");
        JsonToken bytesToken = this.popToken();
        if (bytesToken.getType() != JsonTokenType.UNQUOTED_STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", bytesToken.getValue());
        }
        this.verifyToken(")");
        byte[] bytes = DatatypeConverter.parseBase64Binary((String)bytesToken.getValue(String.class));
        return new BsonBinary(subTypeToken.getValue(Integer.class).byteValue(), bytes);
    }

    private BsonBinary visitUUIDConstructor(String uuidConstructorName) {
        this.verifyToken("(");
        JsonToken bytesToken = this.popToken();
        if (bytesToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", bytesToken.getValue());
        }
        this.verifyToken(")");
        String hexString = bytesToken.getValue(String.class).replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("-", "");
        byte[] bytes = DatatypeConverter.parseHexBinary((String)hexString);
        BsonBinarySubType subType = BsonBinarySubType.UUID_STANDARD;
        if (!"UUID".equals(uuidConstructorName) || !"GUID".equals(uuidConstructorName)) {
            subType = BsonBinarySubType.UUID_LEGACY;
        }
        return new BsonBinary(subType, bytes);
    }

    private BsonRegularExpression visitRegularExpressionConstructor() {
        this.verifyToken("(");
        JsonToken patternToken = this.popToken();
        if (patternToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", patternToken.getValue());
        }
        String options = "";
        JsonToken commaToken = this.popToken();
        if (commaToken.getType() == JsonTokenType.COMMA) {
            JsonToken optionsToken = this.popToken();
            if (optionsToken.getType() != JsonTokenType.STRING) {
                throw new JsonParseException("JSON reader expected a string but found '%s'.", optionsToken.getValue());
            }
            options = optionsToken.getValue(String.class);
        } else {
            this.pushToken(commaToken);
        }
        this.verifyToken(")");
        return new BsonRegularExpression(patternToken.getValue(String.class), options);
    }

    private ObjectId visitObjectIdConstructor() {
        this.verifyToken("(");
        JsonToken valueToken = this.popToken();
        if (valueToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", valueToken.getValue());
        }
        this.verifyToken(")");
        return new ObjectId(valueToken.getValue(String.class));
    }

    private BsonTimestamp visitTimestampConstructor() {
        this.verifyToken("(");
        JsonToken timeToken = this.popToken();
        if (timeToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected an integer but found '%s'.", timeToken.getValue());
        }
        int time = timeToken.getValue(Integer.class);
        this.verifyToken(",");
        JsonToken incrementToken = this.popToken();
        if (incrementToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected an integer but found '%s'.", timeToken.getValue());
        }
        int increment = incrementToken.getValue(Integer.class);
        this.verifyToken(")");
        return new BsonTimestamp(time, increment);
    }

    private BsonDbPointer visitDBPointerConstructor() {
        this.verifyToken("(");
        JsonToken namespaceToken = this.popToken();
        if (namespaceToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", namespaceToken.getValue());
        }
        this.verifyToken(",");
        JsonToken idToken = this.popToken();
        if (namespaceToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", idToken.getValue());
        }
        this.verifyToken(")");
        return new BsonDbPointer(namespaceToken.getValue(String.class), new ObjectId(idToken.getValue(String.class)));
    }

    private long visitNumberLongConstructor() {
        long value;
        this.verifyToken("(");
        JsonToken valueToken = this.popToken();
        if (valueToken.getType() == JsonTokenType.INT32 || valueToken.getType() == JsonTokenType.INT64) {
            value = valueToken.getValue(Long.class);
        } else if (valueToken.getType() == JsonTokenType.STRING) {
            value = Long.parseLong(valueToken.getValue(String.class));
        } else {
            throw new JsonParseException("JSON reader expected an integer or a string but found '%s'.", valueToken.getValue());
        }
        this.verifyToken(")");
        return value;
    }

    private long visitISODateTimeConstructor() {
        this.verifyToken("(");
        JsonToken valueToken = this.popToken();
        if (valueToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", valueToken.getValue());
        }
        this.verifyToken(")");
        String[] patterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss.SSSz"};
        SimpleDateFormat format = new SimpleDateFormat(patterns[0], Locale.ENGLISH);
        ParsePosition pos = new ParsePosition(0);
        String s = valueToken.getValue(String.class);
        if (s.endsWith("Z")) {
            s = s.substring(0, s.length() - 1) + "GMT-00:00";
        }
        for (String pattern : patterns) {
            format.applyPattern(pattern);
            format.setLenient(true);
            pos.setIndex(0);
            Date date = format.parse(s, pos);
            if (date == null || pos.getIndex() != s.length()) continue;
            return date.getTime();
        }
        throw new JsonParseException("Invalid date format.");
    }

    private BsonBinary visitHexDataConstructor() {
        this.verifyToken("(");
        JsonToken subTypeToken = this.popToken();
        if (subTypeToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected a binary subtype but found '%s'.", subTypeToken.getValue());
        }
        this.verifyToken(",");
        JsonToken bytesToken = this.popToken();
        if (bytesToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", bytesToken.getValue());
        }
        this.verifyToken(")");
        String hex = bytesToken.getValue(String.class);
        if ((hex.length() & 1) != 0) {
            hex = "0" + hex;
        }
        for (BsonBinarySubType subType : BsonBinarySubType.values()) {
            if (subType.getValue() != subTypeToken.getValue(Integer.class).intValue()) continue;
            return new BsonBinary(subType, DatatypeConverter.parseHexBinary((String)hex));
        }
        return new BsonBinary(DatatypeConverter.parseHexBinary((String)hex));
    }

    private long visitDateTimeConstructor() {
        SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss z", Locale.ENGLISH);
        this.verifyToken("(");
        JsonToken token = this.popToken();
        if (token.getType() == JsonTokenType.RIGHT_PAREN) {
            return new Date().getTime();
        }
        if (token.getType() == JsonTokenType.STRING) {
            this.verifyToken(")");
            String s = token.getValue(String.class);
            ParsePosition pos = new ParsePosition(0);
            Date dateTime = ((DateFormat)format).parse(s, pos);
            if (dateTime != null && pos.getIndex() == s.length()) {
                return dateTime.getTime();
            }
            throw new JsonParseException("JSON reader expected a date in 'EEE MMM dd yyyy HH:mm:ss z' format but found '%s'.", s);
        }
        if (token.getType() == JsonTokenType.INT32 || token.getType() == JsonTokenType.INT64) {
            int pos;
            long[] values;
            block8: {
                values = new long[7];
                pos = 0;
                do {
                    if (pos < values.length) {
                        values[pos++] = token.getValue(Long.class);
                    }
                    if ((token = this.popToken()).getType() == JsonTokenType.RIGHT_PAREN) break block8;
                    if (token.getType() == JsonTokenType.COMMA) continue;
                    throw new JsonParseException("JSON reader expected a ',' or a ')' but found '%s'.", token.getValue());
                } while ((token = this.popToken()).getType() == JsonTokenType.INT32 || token.getType() == JsonTokenType.INT64);
                throw new JsonParseException("JSON reader expected an integer but found '%s'.", token.getValue());
            }
            if (pos == 1) {
                return values[0];
            }
            if (pos < 3 && pos > 7) {
                throw new JsonParseException("JSON reader expected 1 or 3-7 integers but found %d.", pos);
            }
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.set(1, (int)values[0]);
            calendar.set(2, (int)values[1]);
            calendar.set(5, (int)values[2]);
            calendar.set(11, (int)values[3]);
            calendar.set(12, (int)values[4]);
            calendar.set(13, (int)values[5]);
            calendar.set(14, (int)values[6]);
            return calendar.getTimeInMillis();
        }
        throw new JsonParseException("JSON reader expected an integer or a string but found '%s'.", token.getValue());
    }

    private BsonBinary visitBinDataExtendedJson() {
        this.verifyToken(":");
        JsonToken bytesToken = this.popToken();
        if (bytesToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", bytesToken.getValue());
        }
        this.verifyToken(",");
        this.verifyString("$type");
        this.verifyToken(":");
        JsonToken subTypeToken = this.popToken();
        if (subTypeToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", subTypeToken.getValue());
        }
        this.verifyToken("}");
        byte subType = (byte)Integer.parseInt(subTypeToken.getValue(String.class), 16);
        for (BsonBinarySubType st : BsonBinarySubType.values()) {
            if (st.getValue() != subType) continue;
            return new BsonBinary(st, DatatypeConverter.parseBase64Binary((String)bytesToken.getValue(String.class)));
        }
        return new BsonBinary(DatatypeConverter.parseBase64Binary((String)bytesToken.getValue(String.class)));
    }

    private long visitDateTimeExtendedJson() {
        this.verifyToken(":");
        JsonToken valueToken = this.popToken();
        this.verifyToken("}");
        if (valueToken.getType() == JsonTokenType.INT32 || valueToken.getType() == JsonTokenType.INT64) {
            return valueToken.getValue(Long.class);
        }
        if (valueToken.getType() == JsonTokenType.STRING) {
            String dateTimeString = valueToken.getValue(String.class);
            try {
                return DatatypeConverter.parseDateTime((String)dateTimeString).getTimeInMillis();
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("JSON reader expected an ISO-8601 date time string but found.", dateTimeString);
            }
        }
        throw new JsonParseException("JSON reader expected an integer or string but found '%s'.", valueToken.getValue());
    }

    private MaxKey visitMaxKeyExtendedJson() {
        this.verifyToken(":");
        this.verifyToken(1);
        this.verifyToken("}");
        return new MaxKey();
    }

    private MinKey visitMinKeyExtendedJson() {
        this.verifyToken(":");
        this.verifyToken(1);
        this.verifyToken("}");
        return new MinKey();
    }

    private ObjectId visitObjectIdExtendedJson() {
        this.verifyToken(":");
        JsonToken valueToken = this.popToken();
        if (valueToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", valueToken.getValue());
        }
        this.verifyToken("}");
        return new ObjectId(valueToken.getValue(String.class));
    }

    private BsonRegularExpression visitRegularExpressionExtendedJson() {
        this.verifyToken(":");
        JsonToken patternToken = this.popToken();
        if (patternToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", patternToken.getValue());
        }
        String options = "";
        JsonToken commaToken = this.popToken();
        if (commaToken.getType() == JsonTokenType.COMMA) {
            this.verifyString("$options");
            this.verifyToken(":");
            JsonToken optionsToken = this.popToken();
            if (optionsToken.getType() != JsonTokenType.STRING) {
                throw new JsonParseException("JSON reader expected a string but found '%s'.", optionsToken.getValue());
            }
            options = optionsToken.getValue(String.class);
        } else {
            this.pushToken(commaToken);
        }
        this.verifyToken("}");
        return new BsonRegularExpression(patternToken.getValue(String.class), options);
    }

    private String visitSymbolExtendedJson() {
        this.verifyToken(":");
        JsonToken nameToken = this.popToken();
        if (nameToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", nameToken.getValue());
        }
        this.verifyToken("}");
        return nameToken.getValue(String.class);
    }

    private BsonTimestamp visitTimestampExtendedJson() {
        this.verifyToken(":");
        this.verifyToken("{");
        this.verifyString("t");
        this.verifyToken(":");
        JsonToken timeToken = this.popToken();
        if (timeToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected an integer but found '%s'.", timeToken.getValue());
        }
        int time = timeToken.getValue(Integer.class);
        this.verifyToken(",");
        this.verifyString("i");
        this.verifyToken(":");
        JsonToken incrementToken = this.popToken();
        if (incrementToken.getType() != JsonTokenType.INT32) {
            throw new JsonParseException("JSON reader expected an integer but found '%s'.", timeToken.getValue());
        }
        int increment = incrementToken.getValue(Integer.class);
        this.verifyToken("}");
        this.verifyToken("}");
        return new BsonTimestamp(time, increment);
    }

    private void visitJavaScriptExtendedJson() {
        this.verifyToken(":");
        JsonToken codeToken = this.popToken();
        if (codeToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", codeToken.getValue());
        }
        JsonToken nextToken = this.popToken();
        switch (nextToken.getType()) {
            case COMMA: {
                this.verifyString("$scope");
                this.verifyToken(":");
                this.setState(AbstractBsonReader.State.VALUE);
                this.currentValue = codeToken.getValue();
                this.setCurrentBsonType(BsonType.JAVASCRIPT_WITH_SCOPE);
                this.setContext(new Context((AbstractBsonReader.Context)this.getContext(), BsonContextType.SCOPE_DOCUMENT));
                break;
            }
            case END_OBJECT: {
                this.currentValue = codeToken.getValue();
                this.setCurrentBsonType(BsonType.JAVASCRIPT);
                break;
            }
            default: {
                throw new JsonParseException("JSON reader expected ',' or '}' but found '%s'.", codeToken.getValue());
            }
        }
    }

    private BsonUndefined visitUndefinedExtendedJson() {
        this.verifyToken(":");
        JsonToken nameToken = this.popToken();
        if (!nameToken.getValue(String.class).equals("true")) {
            throw new JsonParseException("JSON reader requires $undefined to have the value of true but found '%s'.", nameToken.getValue());
        }
        this.verifyToken("}");
        return new BsonUndefined();
    }

    private Long visitNumberLongExtendedJson() {
        this.verifyToken(":");
        JsonToken nameToken = this.popToken();
        if (nameToken.getType() != JsonTokenType.STRING) {
            throw new JsonParseException("JSON reader expected a string but found '%s'.", nameToken.getValue());
        }
        this.verifyToken("}");
        return nameToken.getValue(Long.class);
    }

    @Override
    public void mark() {
        if (this.mark != null) {
            throw new BSONException("A mark already exists; it needs to be reset before creating a new one");
        }
        this.mark = new Mark();
    }

    @Override
    public void reset() {
        if (this.mark == null) {
            throw new BSONException("trying to reset a mark before creating it");
        }
        this.mark.reset();
        this.mark = null;
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    protected class Context
    extends AbstractBsonReader.Context {
        protected Context(AbstractBsonReader.Context parentContext, BsonContextType contextType) {
            super(parentContext, contextType);
        }

        @Override
        protected Context getParentContext() {
            return (Context)super.getParentContext();
        }

        @Override
        protected BsonContextType getContextType() {
            return super.getContextType();
        }
    }

    protected class Mark
    extends AbstractBsonReader.Mark {
        private JsonToken pushedToken;
        private Object currentValue;
        private int position;

        protected Mark() {
            this.pushedToken = JsonReader.this.pushedToken;
            this.currentValue = JsonReader.this.currentValue;
            this.position = JsonReader.this.scanner.getBufferPosition();
        }

        @Override
        protected void reset() {
            super.reset();
            JsonReader.this.pushedToken = this.pushedToken;
            JsonReader.this.currentValue = this.currentValue;
            JsonReader.this.scanner.setBufferPosition(this.position);
            JsonReader.this.setContext(new Context(this.getParentContext(), this.getContextType()));
        }
    }
}

