/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecCache;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;

final class CompoundCodecRegistry
implements CodecRegistry {
    private final CodecRegistry firstCodecRegistry;
    private final CodecRegistry secondCodecRegistry;
    private final CodecCache codecCache = new CodecCache();

    CompoundCodecRegistry(CodecRegistry firstCodecRegistry, CodecRegistry secondCodecRegistry) {
        this.firstCodecRegistry = Assertions.notNull("firstCodecRegistry", firstCodecRegistry);
        this.secondCodecRegistry = Assertions.notNull("secondCodecRegistry", secondCodecRegistry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz) {
        if (!this.codecCache.containsKey(clazz)) {
            try {
                Codec<T> codec = this.firstCodecRegistry.get(clazz);
                this.codecCache.put(clazz, codec);
            }
            catch (CodecConfigurationException e) {
                try {
                    Codec<T> codec = this.secondCodecRegistry.get(clazz);
                    this.codecCache.put(clazz, codec);
                }
                catch (CodecConfigurationException e1) {
                    this.codecCache.put(clazz, null);
                }
            }
        }
        return this.codecCache.getOrThrow(clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundCodecRegistry that = (CompoundCodecRegistry)o;
        if (!this.secondCodecRegistry.equals(that.secondCodecRegistry)) {
            return false;
        }
        return this.firstCodecRegistry.equals(that.firstCodecRegistry);
    }

    public int hashCode() {
        int result = this.firstCodecRegistry.hashCode();
        result = 31 * result + this.secondCodecRegistry.hashCode();
        return result;
    }
}

