/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import java.util.Arrays;
import java.util.List;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.configuration.CompoundCodecRegistry;
import org.bson.codecs.configuration.ProvidersCodecRegistry;
import org.bson.codecs.configuration.SingleCodecRegistry;

public final class CodecRegistryHelper {
    public static <T> CodecRegistry fromCodec(Codec<T> codec) {
        return new SingleCodecRegistry<T>(codec);
    }

    public static CodecRegistry fromProvider(CodecProvider codecProvider) {
        return CodecRegistryHelper.fromProviders(Arrays.asList(codecProvider));
    }

    public static CodecRegistry fromProviders(List<CodecProvider> codecProviders) {
        return new ProvidersCodecRegistry(codecProviders);
    }

    public static CodecRegistry fromRegistries(CodecRegistry firstRegistry, CodecRegistry secondRegistry) {
        return new CompoundCodecRegistry(firstRegistry, secondRegistry);
    }

    private CodecRegistryHelper() {
    }
}

