/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.complexPhrase.ComplexPhraseQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.BindVariableName;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.LowerCase;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.UpperCase;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.SelectComponent;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.search.AbstractSearchEngine;
import org.modeshape.graph.search.SearchEngineProcessor;
import org.modeshape.graph.search.SearchEngineWorkspace;
import org.modeshape.search.lucene.LuceneException;
import org.modeshape.search.lucene.LuceneI18n;
import org.modeshape.search.lucene.query.CompareStringQuery;
import org.modeshape.search.lucene.query.HasValueQuery;
import org.modeshape.search.lucene.query.MatchNoneQuery;

public abstract class AbstractLuceneSearchEngine<WorkspaceType extends SearchEngineWorkspace, ProcessorType extends SearchEngineProcessor>
extends AbstractSearchEngine<WorkspaceType, ProcessorType> {
    protected AbstractLuceneSearchEngine(String sourceName, RepositoryConnectionFactory connectionFactory, boolean verifyWorkspaceInSource) {
        super(sourceName, connectionFactory, verifyWorkspaceInSource);
    }

    public static abstract class TupleCollector
    extends Collector {
        public abstract List<Object[]> getTuples();
    }

    @NotThreadSafe
    protected static interface WorkspaceSession {
        public String getWorkspaceName();

        public boolean hasWriters();

        public void rollback();

        public void commit();

        public int getChangeCount();

        public IndexSearcher getContentSearcher() throws IOException;

        public Analyzer getAnalyzer();

        public Version getVersion();

        public TupleCollector createTupleCollector(QueryResults.Columns var1);

        public Query findAllNodesBelow(Path var1) throws IOException;

        public Query findAllNodesAtOrBelow(Path var1) throws IOException;

        public Query findChildNodes(Path var1) throws IOException;

        public Query findNodeAt(Path var1) throws IOException;

        public Query findNodesLike(String var1, String var2, boolean var3) throws IOException;

        public Query findNodesWith(Length var1, Operator var2, Object var3) throws IOException;

        public Query findNodesWith(PropertyValue var1, Operator var2, Object var3, boolean var4) throws IOException;

        public Query findNodesWith(ReferenceValue var1, Operator var2, Object var3) throws IOException;

        public Query findNodesWithNumericRange(PropertyValue var1, Object var2, Object var3, boolean var4, boolean var5) throws IOException;

        public Query findNodesWithNumericRange(NodeDepth var1, Object var2, Object var3, boolean var4, boolean var5) throws IOException;

        public Query findNodesWith(NodePath var1, Operator var2, Object var3, boolean var4) throws IOException;

        public Query findNodesWith(NodeName var1, Operator var2, Object var3, boolean var4) throws IOException;

        public Query findNodesWith(NodeLocalName var1, Operator var2, Object var3, boolean var4) throws IOException;

        public Query findNodesWith(NodeDepth var1, Operator var2, Object var3) throws IOException;
    }

    protected static abstract class AbstractLuceneProcessor<WorkspaceType extends SearchEngineWorkspace, SessionType extends WorkspaceSession>
    extends SearchEngineProcessor {
        private final Map<String, SessionType> workspaceSessions = new HashMap<String, SessionType>();
        protected final boolean readOnly;
        protected final ValueFactories valueFactories;
        protected final ValueFactory<String> stringFactory;
        protected final DateTimeFactory dateFactory;
        protected final PathFactory pathFactory;
        protected final UuidFactory uuidFactory;
        protected final NameFactory nameFactory;
        protected final TypeSystem typeSystem;
        protected final PropertyFactory propertyFactory;
        protected final AbstractSearchEngine.Workspaces<WorkspaceType> workspaces;
        protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

        protected AbstractLuceneProcessor(String sourceName, ExecutionContext context, AbstractSearchEngine.Workspaces<WorkspaceType> workspaces, Observer observer, DateTime now, boolean readOnly) {
            super(sourceName, context, observer, now);
            this.workspaces = workspaces;
            this.readOnly = readOnly;
            this.valueFactories = context.getValueFactories();
            this.stringFactory = this.valueFactories.getStringFactory();
            this.dateFactory = this.valueFactories.getDateFactory();
            this.pathFactory = this.valueFactories.getPathFactory();
            this.uuidFactory = this.valueFactories.getUuidFactory();
            this.nameFactory = this.valueFactories.getNameFactory();
            this.typeSystem = this.valueFactories.getTypeSystem();
            this.propertyFactory = context.getPropertyFactory();
            assert (this.stringFactory != null);
            assert (this.dateFactory != null);
            assert (this.workspaces != null);
        }

        protected abstract SessionType createSessionFor(WorkspaceType var1);

        protected void commit() {
            for (WorkspaceSession session : this.getSessions()) {
                session.commit();
            }
        }

        protected void rollback() {
            for (WorkspaceSession session : this.getSessions()) {
                session.rollback();
            }
        }

        protected WorkspaceType getWorkspace(String workspaceName, boolean createIfMissing) {
            return this.getWorkspace(workspaceName, createIfMissing);
        }

        protected WorkspaceType getWorkspace(Request request, String workspaceName, boolean createIfMissing) {
            SearchEngineWorkspace workspace = this.workspaces.getWorkspace(this.getExecutionContext(), workspaceName, createIfMissing);
            if (workspace == null) {
                if (request != null) {
                    String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{workspaceName, this.getSourceName()});
                    request.setError((Throwable)new InvalidWorkspaceException(msg));
                }
                return null;
            }
            return (WorkspaceType)workspace;
        }

        protected SessionType getSessionFor(Request request, String workspaceName) {
            return this.getSessionFor(request, workspaceName, true);
        }

        protected SessionType getSessionFor(Request request, String workspaceName, boolean createIfMissing) {
            WorkspaceSession result = (WorkspaceSession)this.workspaceSessions.get(workspaceName);
            if (result == null) {
                WorkspaceType workspace = this.getWorkspace(request, workspaceName, createIfMissing);
                if (workspace == null) {
                    return null;
                }
                result = this.createSessionFor(workspace);
                this.workspaceSessions.put(workspaceName, result);
            }
            return (SessionType)result;
        }

        protected Collection<SessionType> getSessions() {
            return this.workspaceSessions.values();
        }

        protected final String serializeProperty(Property property) {
            StringBuilder sb = new StringBuilder();
            sb.append((String)this.stringFactory.create(property.getName()));
            sb.append('=');
            Iterator iter = property.getValues();
            if (iter.hasNext()) {
                sb.append((String)this.stringFactory.create(iter.next()));
            }
            while (iter.hasNext()) {
                sb.append('\n');
                sb.append((String)this.stringFactory.create(iter.next()));
            }
            return sb.toString();
        }

        protected final Property deserializeProperty(String propertyString) {
            int index = propertyString.indexOf(61);
            assert (index > -1);
            if (index == propertyString.length() - 1) {
                return null;
            }
            Name propName = (Name)this.nameFactory.create(propertyString.substring(0, index));
            String valueString = propertyString.substring(index + 1);
            String[] values = valueString.split("\\n");
            if (values.length == 0) {
                return null;
            }
            if (values.length == 1) {
                Object value = values[0];
                if (ModeShapeLexicon.UUID.equals(propName) || JcrLexicon.UUID.equals(propName)) {
                    value = this.uuidFactory.create(value);
                }
                return this.propertyFactory.create(propName, new Object[]{value});
            }
            LinkedList<String> propValues = new LinkedList<String>();
            for (String value : values) {
                propValues.add(value);
            }
            return this.propertyFactory.create(propName, propValues);
        }

        protected abstract String fullTextFieldName(String var1);

        public boolean hasChanges() {
            for (WorkspaceSession session : this.getSessions()) {
                if (session.getChangeCount() <= 0) continue;
                return true;
            }
            return false;
        }

        public String pathAsString(Path path) {
            assert (path != null);
            if (path.isRoot()) {
                return "/";
            }
            StringBuilder sb = new StringBuilder();
            for (Path.Segment segment : path) {
                sb.append('/');
                sb.append((String)this.stringFactory.create(segment.getName()));
                sb.append('[');
                sb.append(segment.getIndex());
                sb.append(']');
            }
            return sb.toString();
        }

        public void process(AccessQueryRequest request) {
            SessionType session = this.getSessionFor((Request)request, request.workspace());
            if (session == null) {
                return;
            }
            long planningNanos = System.nanoTime();
            MatchAllDocsQuery pushDownQuery = null;
            Constraint postProcessConstraint = null;
            try {
                QueryFactory queryFactory = null;
                for (Constraint andedConstraint : request.andedConstraints()) {
                    Query constraintQuery;
                    assert (andedConstraint != null);
                    if (queryFactory == null) {
                        queryFactory = this.queryFactory((WorkspaceSession)session, request.variables());
                    }
                    if ((constraintQuery = queryFactory.createQuery(andedConstraint)) != null) {
                        if (constraintQuery instanceof MatchAllDocsQuery) continue;
                        if (constraintQuery instanceof MatchNoneQuery) {
                            pushDownQuery = constraintQuery;
                            break;
                        }
                        if (pushDownQuery == null) {
                            pushDownQuery = constraintQuery;
                            continue;
                        }
                        pushDownQuery = this.andQueries((Query)pushDownQuery, constraintQuery);
                        continue;
                    }
                    if (postProcessConstraint == null) {
                        postProcessConstraint = andedConstraint;
                        continue;
                    }
                    postProcessConstraint = new And(postProcessConstraint, andedConstraint);
                }
            }
            catch (IOException e) {
                request.setError((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                request.setError((Throwable)e);
                return;
            }
            if (pushDownQuery == null) {
                pushDownQuery = new MatchAllDocsQuery();
            }
            long executingNanos = System.nanoTime();
            planningNanos = executingNanos - planningNanos;
            List<Object> tuples = null;
            QueryResults.Columns columns = request.resultColumns();
            if (pushDownQuery instanceof MatchNoneQuery) {
                tuples = Collections.emptyList();
            } else {
                try {
                    IndexSearcher searcher = session.getContentSearcher();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("query \"{0}\" workspace: {1}", new Object[]{session.getWorkspaceName(), pushDownQuery});
                    }
                    TupleCollector collector = session.createTupleCollector(columns);
                    searcher.search((Query)pushDownQuery, (Collector)collector);
                    tuples = collector.getTuples();
                }
                catch (IOException e) {
                    request.setError((Throwable)e);
                    return;
                }
            }
            if (!tuples.isEmpty()) {
                Limit limit;
                if (postProcessConstraint != null) {
                    final List allTuples = tuples;
                    QueryContext queryContext = new QueryContext(request.schemata(), this.typeSystem, null, (Problems)new SimpleProblems(), request.variables());
                    ProcessingComponent tuplesProcessor = new ProcessingComponent(queryContext, columns){

                        public List<Object[]> execute() {
                            return allTuples;
                        }
                    };
                    SelectComponent selector = new SelectComponent(tuplesProcessor, postProcessConstraint, request.variables());
                    tuples = selector.execute();
                }
                if (!(limit = request.limit()).isUnlimited()) {
                    int firstIndex = limit.offset();
                    int maxRows = Math.min(tuples.size(), limit.rowLimit());
                    if (firstIndex > 0) {
                        if (firstIndex > tuples.size()) {
                            tuples.clear();
                        } else {
                            tuples = tuples.subList(firstIndex, maxRows);
                        }
                    } else {
                        tuples = tuples.subList(0, maxRows);
                    }
                }
            }
            executingNanos = System.nanoTime() - executingNanos;
            QueryResults.Statistics stats = new QueryResults.Statistics(planningNanos, 0L, 0L, executingNanos);
            request.setResults(tuples, stats);
        }

        protected Query andQueries(Query first, Query second) {
            BooleanQuery booleanSecond;
            BooleanQuery booleanQuery;
            if (first instanceof BooleanQuery) {
                booleanQuery = (BooleanQuery)first;
                boolean canMerge = true;
                for (BooleanClause clause : booleanQuery.getClauses()) {
                    if (clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                    canMerge = false;
                    break;
                }
                if (canMerge) {
                    booleanQuery.add(second, BooleanClause.Occur.MUST);
                    return booleanQuery;
                }
            }
            booleanQuery = new BooleanQuery();
            booleanQuery.add(first, BooleanClause.Occur.MUST);
            boolean done = false;
            if (second instanceof BooleanQuery && (booleanSecond = (BooleanQuery)second).getClauses().length == 1) {
                BooleanClause onlyClause = booleanSecond.getClauses()[0];
                if (onlyClause.isProhibited()) {
                    booleanQuery.add(onlyClause.getQuery(), BooleanClause.Occur.MUST_NOT);
                    done = true;
                } else if (onlyClause.isRequired()) {
                    booleanQuery.add(onlyClause.getQuery(), BooleanClause.Occur.MUST);
                    done = true;
                }
            }
            if (!done) {
                booleanQuery.add(second, BooleanClause.Occur.MUST);
            }
            return booleanQuery;
        }

        protected QueryFactory queryFactory(WorkspaceSession session, Map<String, Object> variables) {
            return new QueryFactory(session, variables);
        }

        protected class QueryFactory {
            private final WorkspaceSession session;
            private final Map<String, Object> variables;

            protected QueryFactory(WorkspaceSession session, Map<String, Object> variables) {
                this.session = session;
                this.variables = variables;
            }

            public Query createQuery(Constraint constraint) throws IOException {
                if (constraint instanceof And) {
                    And and = (And)constraint;
                    Query leftQuery = this.createQuery(and.left());
                    Query rightQuery = this.createQuery(and.right());
                    if (leftQuery == null || rightQuery == null) {
                        return null;
                    }
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add(leftQuery, BooleanClause.Occur.MUST);
                    booleanQuery.add(rightQuery, BooleanClause.Occur.MUST);
                    return booleanQuery;
                }
                if (constraint instanceof Or) {
                    Or or = (Or)constraint;
                    Query leftQuery = this.createQuery(or.left());
                    Query rightQuery = this.createQuery(or.right());
                    if (leftQuery == null) {
                        return rightQuery != null ? rightQuery : null;
                    }
                    if (rightQuery == null) {
                        return leftQuery;
                    }
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add(leftQuery, BooleanClause.Occur.SHOULD);
                    booleanQuery.add(rightQuery, BooleanClause.Occur.SHOULD);
                    return booleanQuery;
                }
                if (constraint instanceof Not) {
                    Not not = (Not)constraint;
                    Query notted = this.createQuery(not.constraint());
                    if (notted == null) {
                        return new MatchAllDocsQuery();
                    }
                    BooleanQuery query = new BooleanQuery();
                    query.add(notted, BooleanClause.Occur.MUST_NOT);
                    return query;
                }
                if (constraint instanceof SetCriteria) {
                    StaticOperand rightOperand;
                    SetCriteria setCriteria = (SetCriteria)constraint;
                    DynamicOperand left = setCriteria.leftOperand();
                    int numRightOperands = setCriteria.rightOperands().size();
                    assert (numRightOperands > 0);
                    if (numRightOperands == 1 && (rightOperand = (StaticOperand)setCriteria.rightOperands().iterator().next()) instanceof Literal) {
                        return this.createQuery(left, Operator.EQUAL_TO, (StaticOperand)setCriteria.rightOperands().iterator().next());
                    }
                    BooleanQuery setQuery = new BooleanQuery();
                    for (StaticOperand right : setCriteria.rightOperands()) {
                        if (right instanceof BindVariableName) {
                            BindVariableName var = (BindVariableName)right;
                            Object value = this.variables.get(var.variableName());
                            if (value instanceof Iterable) {
                                for (Object resolvedValue : (Iterable)value) {
                                    if (resolvedValue == null) continue;
                                    Literal elementInRight = null;
                                    elementInRight = resolvedValue instanceof Literal ? (Literal)resolvedValue : new Literal(resolvedValue);
                                    Query rightQuery = this.createQuery(left, Operator.EQUAL_TO, (StaticOperand)elementInRight);
                                    if (rightQuery == null) continue;
                                    setQuery.add(rightQuery, BooleanClause.Occur.SHOULD);
                                }
                            }
                            if (value != null) continue;
                            throw new LuceneException(LuceneI18n.missingVariableValue.text(new Object[]{var.variableName()}));
                        }
                        Query rightQuery = this.createQuery(left, Operator.EQUAL_TO, right);
                        if (rightQuery == null) {
                            return null;
                        }
                        setQuery.add(rightQuery, BooleanClause.Occur.SHOULD);
                    }
                    return setQuery;
                }
                if (constraint instanceof PropertyExistence) {
                    PropertyExistence existence = (PropertyExistence)constraint;
                    return this.createQuery(existence);
                }
                if (constraint instanceof Between) {
                    Between between = (Between)constraint;
                    DynamicOperand operand = between.operand();
                    StaticOperand lower = between.lowerBound();
                    StaticOperand upper = between.upperBound();
                    return this.createQuery(operand, lower, upper, between.isLowerBoundIncluded(), between.isUpperBoundIncluded(), true);
                }
                if (constraint instanceof Comparison) {
                    Comparison comparison = (Comparison)constraint;
                    return this.createQuery(comparison.operand1(), comparison.operator(), comparison.operand2());
                }
                if (constraint instanceof FullTextSearch) {
                    FullTextSearch search = (FullTextSearch)constraint;
                    String propertyName = search.propertyName();
                    if (propertyName != null) {
                        propertyName = this.fieldNameFor(propertyName);
                    }
                    String fieldName = AbstractLuceneProcessor.this.fullTextFieldName(propertyName);
                    return this.createQuery(fieldName, search.getTerm());
                }
                if (constraint instanceof SameNode) {
                    SameNode sameNode = (SameNode)constraint;
                    Path path = (Path)AbstractLuceneProcessor.this.pathFactory.create(sameNode.path());
                    return this.session.findNodeAt(path);
                }
                if (constraint instanceof ChildNode) {
                    ChildNode childNode = (ChildNode)constraint;
                    Path path = (Path)AbstractLuceneProcessor.this.pathFactory.create(childNode.parentPath());
                    return this.session.findChildNodes(path);
                }
                if (constraint instanceof DescendantNode) {
                    DescendantNode descendantNode = (DescendantNode)constraint;
                    Path path = (Path)AbstractLuceneProcessor.this.pathFactory.create(descendantNode.ancestorPath());
                    return this.session.findAllNodesBelow(path);
                }
                assert (false);
                return null;
            }

            public Query createQuery(DynamicOperand left, Operator operator, StaticOperand right) throws IOException {
                return this.createQuery(left, operator, right, true);
            }

            public Query createQuery(DynamicOperand left, Operator operator, StaticOperand right, boolean caseSensitive) throws IOException {
                Object value = this.createOperand(right, caseSensitive);
                assert (value != null);
                if (left instanceof FullTextSearchScore) {
                    return null;
                }
                if (left instanceof PropertyValue) {
                    return this.session.findNodesWith((PropertyValue)left, operator, value, caseSensitive);
                }
                if (left instanceof ReferenceValue) {
                    return this.session.findNodesWith((ReferenceValue)left, operator, value);
                }
                if (left instanceof Length) {
                    return this.session.findNodesWith((Length)left, operator, (Object)right);
                }
                if (left instanceof LowerCase) {
                    LowerCase lowercase = (LowerCase)left;
                    return this.createQuery(lowercase.operand(), operator, right, false);
                }
                if (left instanceof UpperCase) {
                    UpperCase lowercase = (UpperCase)left;
                    return this.createQuery(lowercase.operand(), operator, right, false);
                }
                if (left instanceof NodeDepth) {
                    assert (operator != Operator.LIKE);
                    return this.session.findNodesWith((NodeDepth)left, operator, value);
                }
                if (left instanceof NodePath) {
                    return this.session.findNodesWith((NodePath)left, operator, value, caseSensitive);
                }
                if (left instanceof NodeName) {
                    return this.session.findNodesWith((NodeName)left, operator, value, caseSensitive);
                }
                if (left instanceof NodeLocalName) {
                    return this.session.findNodesWith((NodeLocalName)left, operator, value, caseSensitive);
                }
                assert (false);
                return null;
            }

            public Object createOperand(StaticOperand operand, boolean caseSensitive) {
                Object value = null;
                if (operand instanceof Literal) {
                    Literal literal = (Literal)operand;
                    value = literal.value();
                    if (!caseSensitive) {
                        value = this.lowerCase(value);
                    }
                } else if (operand instanceof BindVariableName) {
                    BindVariableName variable = (BindVariableName)operand;
                    String variableName = variable.variableName();
                    value = this.variables.get(variableName);
                    if (value instanceof Iterable) {
                        Iterator iter = ((Iterable)value).iterator();
                        if (iter.hasNext()) {
                            return iter.next();
                        }
                        value = null;
                    }
                    if (value == null) {
                        throw new LuceneException(LuceneI18n.missingVariableValue.text(new Object[]{variableName}));
                    }
                    if (!caseSensitive) {
                        value = this.lowerCase(value);
                    }
                } else assert (false);
                return value;
            }

            public Query createQuery(DynamicOperand left, StaticOperand lower, StaticOperand upper, boolean includesLower, boolean includesUpper, boolean caseSensitive) throws IOException {
                Object lowerValue = this.createOperand(lower, caseSensitive);
                Object upperValue = this.createOperand(upper, caseSensitive);
                assert (lowerValue != null);
                assert (upperValue != null);
                if (left instanceof NodeDepth) {
                    return this.session.findNodesWithNumericRange((NodeDepth)left, lowerValue, upperValue, includesLower, includesUpper);
                }
                if (left instanceof PropertyValue) {
                    PropertyType lowerType = PropertyType.discoverType((Object)lowerValue);
                    PropertyType upperType = PropertyType.discoverType((Object)upperValue);
                    if (upperType == lowerType) {
                        switch (upperType) {
                            case DATE: 
                            case LONG: 
                            case DOUBLE: 
                            case DECIMAL: {
                                return this.session.findNodesWithNumericRange((PropertyValue)left, lowerValue, upperValue, includesLower, includesUpper);
                            }
                        }
                    }
                }
                BooleanQuery query = new BooleanQuery();
                Operator lowerOp = includesLower ? Operator.GREATER_THAN_OR_EQUAL_TO : Operator.GREATER_THAN;
                Operator upperOp = includesUpper ? Operator.LESS_THAN_OR_EQUAL_TO : Operator.LESS_THAN;
                Query lowerQuery = this.createQuery(left, lowerOp, lower, caseSensitive);
                Query upperQuery = this.createQuery(left, upperOp, upper, caseSensitive);
                if (lowerQuery == null || upperQuery == null) {
                    return null;
                }
                query.add(lowerQuery, BooleanClause.Occur.MUST);
                query.add(upperQuery, BooleanClause.Occur.MUST);
                return query;
            }

            public Object lowerCase(Object value) {
                if (value instanceof String) {
                    return ((String)value).toLowerCase();
                }
                assert (!(value instanceof Binary));
                TypeSystem.TypeFactory stringFactory = AbstractLuceneProcessor.this.typeSystem.getStringFactory();
                TypeSystem.TypeFactory valueFactory = AbstractLuceneProcessor.this.typeSystem.getTypeFactory(value);
                return valueFactory.create(((String)stringFactory.create(value)).toLowerCase());
            }

            public Query createQuery(PropertyExistence existence) {
                String propertyName = existence.propertyName();
                if ("jcr:primaryType".equals(propertyName)) {
                    return new MatchAllDocsQuery();
                }
                return new HasValueQuery(this.fieldNameFor(propertyName));
            }

            public Query createQuery(String fieldName, FullTextSearch.Term term) throws IOException {
                assert (fieldName != null);
                if (term instanceof FullTextSearch.Conjunction) {
                    FullTextSearch.Conjunction conjunction = (FullTextSearch.Conjunction)term;
                    BooleanQuery query = new BooleanQuery();
                    for (FullTextSearch.Term nested : conjunction) {
                        if (nested instanceof FullTextSearch.NegationTerm) {
                            query.add(this.createQuery(fieldName, ((FullTextSearch.NegationTerm)nested).getNegatedTerm()), BooleanClause.Occur.MUST_NOT);
                            continue;
                        }
                        query.add(this.createQuery(fieldName, nested), BooleanClause.Occur.MUST);
                    }
                    return query;
                }
                if (term instanceof FullTextSearch.Disjunction) {
                    FullTextSearch.Disjunction disjunction = (FullTextSearch.Disjunction)term;
                    BooleanQuery query = new BooleanQuery();
                    for (FullTextSearch.Term nested : disjunction) {
                        if (nested instanceof FullTextSearch.NegationTerm) {
                            query.add(this.createQuery(fieldName, ((FullTextSearch.NegationTerm)nested).getNegatedTerm()), BooleanClause.Occur.MUST_NOT);
                            continue;
                        }
                        query.add(this.createQuery(fieldName, nested), BooleanClause.Occur.SHOULD);
                    }
                    return query;
                }
                if (term instanceof FullTextSearch.SimpleTerm) {
                    FullTextSearch.SimpleTerm simple = (FullTextSearch.SimpleTerm)term;
                    Analyzer analyzer = this.session.getAnalyzer();
                    if (simple.containsWildcards()) {
                        ComplexPhraseQueryParser parser = new ComplexPhraseQueryParser(this.session.getVersion(), fieldName, analyzer){

                            protected Query getWildcardQuery(String field, String termStr) {
                                return CompareStringQuery.createQueryForNodesWithFieldLike(termStr, field, AbstractLuceneProcessor.this.valueFactories, false);
                            }
                        };
                        try {
                            String expression = simple.getValue();
                            expression = expression.replaceAll("(?<![\\\\])_", "?");
                            expression = expression.replaceAll("(?<![\\\\])%", "*");
                            expression = expression.replaceAll("((?<![\\d*?]))[-]((?![\\d*?]))", "$1 $2");
                            Query query = parser.parse(expression);
                            return query;
                        }
                        catch (ParseException e) {
                            throw new IOException(e);
                        }
                    }
                    PhraseQuery query = new PhraseQuery();
                    query.setSlop(0);
                    String expression = simple.getValue();
                    TokenStream stream = this.session.getAnalyzer().tokenStream(fieldName, (Reader)new StringReader(expression));
                    TermAttribute termAttribute = (TermAttribute)stream.addAttribute(TermAttribute.class);
                    while (stream.incrementToken()) {
                        String analyzedTerm = termAttribute.term();
                        query.add(new Term(fieldName, analyzedTerm));
                    }
                    return query;
                }
                assert (false);
                return null;
            }

            public String fieldNameFor(String name) {
                return (String)AbstractLuceneProcessor.this.stringFactory.create((Name)AbstractLuceneProcessor.this.nameFactory.create(name));
            }
        }
    }
}

