/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.record;

import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.List;
import java.util.stream.IntStream;
import org.modelmapper.ConstructorParam;
import org.modelmapper.spi.ConstructorInjector;

public class RecordConstructorInjector
implements ConstructorInjector {
    public List<ConstructorParam> getParameters(Class<?> type) {
        if (!this.isApplicable(type)) {
            throw new IllegalArgumentException(String.format("Type %s is not a Record type.", type.getName()));
        }
        Constructor<?> constructor = type.getDeclaredConstructors()[0];
        RecordComponent[] components = type.getRecordComponents();
        return IntStream.range(0, components.length).mapToObj(index -> new ConstructorParam(constructor, index, components[index].getName(), components[index].getType())).toList();
    }

    public boolean isApplicable(Class<?> type) {
        return Record.class.isAssignableFrom(type);
    }
}

