/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.flattening.example2;

import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.modelmapper.convention.MatchingStrategies;
import org.modelmapper.flattening.example2.Address;
import org.modelmapper.flattening.example2.Person;
import org.modelmapper.flattening.example2.PersonDTO;
import org.testng.Assert;

public class FlatteningExample2 {
    public static void main(String ... args) throws Exception {
        Person person = new Person();
        Address address = new Address();
        address.setStreet("1234 Main street");
        address.setCity("San Francisco");
        person.setAddress(address);
        ModelMapper modelMapper = new ModelMapper();
        PropertyMap<Person, PersonDTO> personMap = new PropertyMap<Person, PersonDTO>(){

            protected void configure() {
                ((PersonDTO)this.map()).setStreet(((Person)this.source).getAddress().getStreet());
                this.map(((Person)this.source).getAddress().city, ((PersonDTO)this.destination).city);
            }
        };
        modelMapper.addMappings((PropertyMap)personMap);
        PersonDTO dto = (PersonDTO)modelMapper.map((Object)person, PersonDTO.class);
        Assert.assertEquals((String)dto.getStreet(), (String)person.getAddress().getStreet());
        Assert.assertEquals((String)dto.getCity(), (String)person.getAddress().getCity());
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.LOOSE);
        dto = (PersonDTO)modelMapper.map((Object)person, PersonDTO.class);
        Assert.assertEquals((String)dto.getStreet(), (String)person.getAddress().getStreet());
        Assert.assertEquals((String)dto.getCity(), (String)person.getAddress().getCity());
    }
}

