/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.modelmapper.internal.Errors;
import org.modelmapper.protobuf.ProtobufHelper;
import org.modelmapper.spi.ValueReader;

public class ProtobufValueReader
implements ValueReader<MessageOrBuilder> {
    public Object get(MessageOrBuilder source, String memberName) {
        try {
            Method method = ProtobufHelper.getter(source.getClass(), memberName);
            return method.invoke((Object)source, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
        }
        catch (IllegalAccessException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
        }
        catch (InvocationTargetException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
        }
    }

    public ValueReader.Member<MessageOrBuilder> getMember(MessageOrBuilder source, String memberName) {
        try {
            final Method getter = ProtobufHelper.getter(source.getClass(), memberName);
            final Object value = getter.invoke((Object)source, new Object[0]);
            if (Message.class.isAssignableFrom(getter.getReturnType())) {
                final Method hasMethod = ProtobufHelper.hasMethod(source.getClass(), memberName);
                return new ValueReader.Member<MessageOrBuilder>(getter.getReturnType()){

                    public MessageOrBuilder getOrigin() {
                        return MessageOrBuilder.class.isAssignableFrom(value.getClass()) ? (MessageOrBuilder)value : null;
                    }

                    public Object get(MessageOrBuilder source, String memberName) {
                        try {
                            if (Boolean.TRUE.equals(hasMethod.invoke((Object)source, new Object[0]))) {
                                return getter.invoke((Object)source, new Object[0]);
                            }
                            return null;
                        }
                        catch (IllegalAccessException e) {
                            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
                        }
                        catch (InvocationTargetException e) {
                            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
                        }
                    }
                };
            }
            return new ValueReader.Member<MessageOrBuilder>(getter.getReturnType()){

                public MessageOrBuilder getOrigin() {
                    return MessageOrBuilder.class.isAssignableFrom(value.getClass()) ? (MessageOrBuilder)value : null;
                }

                public Object get(MessageOrBuilder source, String memberName) {
                    try {
                        return getter.invoke((Object)source, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
                    }
                    catch (InvocationTargetException e) {
                        throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toMappingException();
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toConfigurationException();
        }
        catch (IllegalAccessException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toConfigurationException();
        }
        catch (InvocationTargetException e) {
            throw new Errors().addMessage((Throwable)e, "Cannot get the member", new Object[0]).toConfigurationException();
        }
    }

    public Collection<String> memberNames(MessageOrBuilder source) {
        return ProtobufHelper.fields(source.getClass());
    }
}

