/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.modelmapper.internal.Errors;

public class ProtobufHelper {
    private ProtobufHelper() {
    }

    public static boolean hasBuilder(Class<?> builderType, String field) {
        return ProtobufHelper.builder(builderType, field) != null;
    }

    public static Class<? extends Message.Builder> builder(Class<?> builderType, String field) {
        try {
            String methodName = "get" + ProtobufHelper.firstCharToUpperCase(field) + "Builder";
            return builderType.getMethod(methodName, new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static List<String> fields(Class<?> type) {
        if (Message.Builder.class.isAssignableFrom(type)) {
            return ProtobufHelper.fieldsOfMessage(ProtobufHelper.messageOfBuilder(type));
        }
        if (Message.class.isAssignableFrom(type)) {
            return ProtobufHelper.fieldsOfMessage(type);
        }
        throw new Errors().addMessage("Invalid protocol buffer type: %s", new Object[]{type.getName()}).toConfigurationException();
    }

    public static Method getter(Class<?> type, String field) throws NoSuchMethodException {
        String methodName = "get" + ProtobufHelper.firstCharToUpperCase(field);
        return type.getMethod(methodName, new Class[0]);
    }

    public static Class<?> messageOfBuilder(Class<?> builderType) {
        try {
            Method buildMethod = builderType.getDeclaredMethod("build", new Class[0]);
            return buildMethod.getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Invalid protocol buffer type", new Object[0]).toConfigurationException();
        }
    }

    public static Method setterForBuilder(Class<?> type, String field) throws NoSuchMethodException {
        String methodName = "set" + ProtobufHelper.firstCharToUpperCase(field);
        for (Method method : type.getMethods()) {
            if (!ProtobufHelper.isSetterForBuilder(method, methodName)) continue;
            return method;
        }
        throw new NoSuchMethodException(methodName);
    }

    public static Method setter(Class<?> type, String field) throws NoSuchMethodException {
        String methodName = "set" + ProtobufHelper.firstCharToUpperCase(field);
        for (Method method : type.getMethods()) {
            if (!ProtobufHelper.isSetterForPrimitive(method, methodName)) continue;
            return method;
        }
        throw new NoSuchMethodException(methodName);
    }

    public static Method hasMethod(Class<?> type, String field) throws NoSuchMethodException {
        String methodName = "has" + ProtobufHelper.firstCharToUpperCase(field);
        return type.getMethod(methodName, new Class[0]);
    }

    private static List<String> fieldsOfMessage(Class<?> type) {
        try {
            Method descriptorMethod = type.getDeclaredMethod("getDescriptor", new Class[0]);
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)descriptorMethod.invoke(type, new Object[0]);
            ArrayList<String> fields = new ArrayList<String>();
            for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
                fields.add(field.getName());
            }
            return fields;
        }
        catch (NoSuchMethodException e) {
            throw new Errors().addMessage((Throwable)e, "Invalid protocol buffer type", new Object[0]).toConfigurationException();
        }
        catch (IllegalAccessException e) {
            throw new Errors().addMessage((Throwable)e, "Invalid protocol buffer type", new Object[0]).toConfigurationException();
        }
        catch (InvocationTargetException e) {
            throw new Errors().addMessage((Throwable)e, "Invalid protocol buffer type", new Object[0]).toConfigurationException();
        }
    }

    private static String firstCharToUpperCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static boolean isSetterForPrimitive(Method method, String methodName) {
        if (!method.getName().equalsIgnoreCase(methodName)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && !Message.Builder.class.isAssignableFrom(parameterTypes[0]);
    }

    private static boolean isSetterForBuilder(Method method, String methodName) {
        if (!method.getName().equalsIgnoreCase(methodName)) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && Message.Builder.class.isAssignableFrom(parameterTypes[0]);
    }
}

