/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.modelmapper.internal.util.Lists;
import org.modelmapper.spi.ValueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonNodeValueReader
implements ValueReader<JsonNode> {
    public Object get(JsonNode source, String memberName) {
        JsonNode propertyNode = source.get(memberName);
        if (propertyNode == null) {
            throw new IllegalArgumentException();
        }
        switch (propertyNode.getNodeType()) {
            case BOOLEAN: {
                return propertyNode.asBoolean();
            }
            case NULL: {
                return null;
            }
            case NUMBER: {
                return ((NumericNode)propertyNode).numberValue();
            }
            case POJO: {
                return ((POJONode)propertyNode).getPojo();
            }
            case STRING: {
                return propertyNode.asText();
            }
            case BINARY: {
                try {
                    return propertyNode.binaryValue();
                }
                catch (IOException ignore) {
                    return null;
                }
            }
        }
        return propertyNode;
    }

    public Collection<String> memberNames(JsonNode source) {
        if (source.isObject()) {
            return Lists.from((Iterator)((ObjectNode)source).fieldNames());
        }
        return null;
    }

    public String toString() {
        return "Jackson";
    }
}

