/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.testng;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.internal.util.reflection.InstanceField;
import org.mockito.quality.Strictness;
import org.mockito.testng.MockitoSettings;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

public class MockitoTestNGListener
implements IInvokedMethodListener {
    private final Map<Object, MockitoSession> sessions = new HashMap<Object, MockitoSession>();
    private final Map<Object, Map<InstanceField, Object>> injectMocksFieldsValues = new HashMap<Object, Map<InstanceField, Object>>();

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.shouldBeRunBeforeInvocation(method, testResult)) {
            this.injectMocksFieldsValues.computeIfAbsent(testResult.getInstance(), testInstance -> MockitoTestNGListener.allDeclaredFieldsOf(testInstance).stream().filter(field -> field.isAnnotatedBy(InjectMocks.class)).collect(HashMap::new, (m, v) -> m.put(v, v.read()), HashMap::putAll));
            this.sessions.computeIfAbsent(testResult.getInstance(), testInstance -> {
                Strictness strictness = this.findAnnotation(testResult, MockitoSettings.class).map(MockitoSettings::strictness).orElse(Strictness.STRICT_STUBS);
                return Mockito.mockitoSession().initMocks(testInstance).strictness(strictness).startMocking();
            });
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.shouldBeRunAfterInvocation(method, testResult)) {
            try {
                Optional.ofNullable(this.sessions.remove(testResult.getInstance())).ifPresent(mockitoSession -> mockitoSession.finishMocking(testResult.getThrowable()));
            }
            finally {
                Optional.ofNullable(this.injectMocksFieldsValues.remove(testResult.getInstance())).ifPresent(fieldsValues -> fieldsValues.forEach(InstanceField::set));
            }
        }
    }

    private boolean shouldBeRunBeforeInvocation(IInvokedMethod method, ITestResult testResult) {
        return (method.isTestMethod() || this.isBeforeMethod(method)) && this.hasMockitoTestNGListener(testResult);
    }

    private boolean isBeforeMethod(IInvokedMethod method) {
        return method.getTestMethod().isBeforeMethodConfiguration();
    }

    private boolean shouldBeRunAfterInvocation(IInvokedMethod method, ITestResult testResult) {
        return method.isTestMethod() && this.hasMockitoTestNGListener(testResult);
    }

    protected boolean hasMockitoTestNGListener(ITestResult testResult) {
        return this.findAnnotation(testResult, Listeners.class).map(Listeners::value).map(Arrays::stream).orElseGet(Stream::empty).anyMatch(listener -> listener == MockitoTestNGListener.class);
    }

    <A extends Annotation> Optional<A> findAnnotation(ITestResult testResult, Class<A> annotationClass) {
        for (Class clazz = testResult.getTestClass().getRealClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Optional<A> annotation = Optional.ofNullable(clazz.getAnnotation(annotationClass));
            if (!annotation.isPresent()) continue;
            return annotation;
        }
        return Optional.empty();
    }

    private static List<InstanceField> allDeclaredFieldsOf(Object testInstance) {
        ArrayList<InstanceField> result = new ArrayList<InstanceField>();
        for (Class<?> clazz = testInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                result.add(new InstanceField(field, testInstance));
            }
        }
        return result;
    }
}

