/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.testng;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.quality.Strictness;
import org.mockito.testng.MockitoSettings;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

public class MockitoTestNGListener
implements IInvokedMethodListener {
    private final Map<Object, MockitoSession> sessions = new WeakHashMap<Object, MockitoSession>();

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.shouldBeRunBeforeInvocation(method, testResult)) {
            this.sessions.computeIfAbsent(testResult.getInstance(), testInstance -> {
                Strictness strictness = this.findAnnotation(testResult, MockitoSettings.class).map(MockitoSettings::strictness).orElse(Strictness.STRICT_STUBS);
                return Mockito.mockitoSession().initMocks(testInstance).strictness(strictness).startMocking();
            });
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.shouldBeRunAfterInvocation(method, testResult)) {
            Optional.ofNullable(this.sessions.remove(testResult.getInstance())).ifPresent(mockitoSession -> mockitoSession.finishMocking(testResult.getThrowable()));
        }
    }

    private boolean shouldBeRunBeforeInvocation(IInvokedMethod method, ITestResult testResult) {
        return !this.isAfterConfigurationMethod(method) && this.hasMockitoTestNGListener(testResult);
    }

    private boolean isAfterConfigurationMethod(IInvokedMethod method) {
        ITestNGMethod testMethod = method.getTestMethod();
        return testMethod.isAfterClassConfiguration() || testMethod.isAfterMethodConfiguration() || testMethod.isAfterGroupsConfiguration() || testMethod.isAfterTestConfiguration() || testMethod.isAfterSuiteConfiguration();
    }

    private boolean shouldBeRunAfterInvocation(IInvokedMethod method, ITestResult testResult) {
        return method.isTestMethod() && this.hasMockitoTestNGListener(testResult);
    }

    protected boolean hasMockitoTestNGListener(ITestResult testResult) {
        return this.findAnnotation(testResult, Listeners.class).map(Listeners::value).map(Arrays::stream).orElseGet(Stream::empty).anyMatch(listener -> listener == MockitoTestNGListener.class);
    }

    <A extends Annotation> Optional<A> findAnnotation(ITestResult testResult, Class<A> annotationClass) {
        for (Class clazz = testResult.getTestClass().getRealClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Optional<A> annotation = Optional.ofNullable(clazz.getAnnotation(annotationClass));
            if (!annotation.isPresent()) continue;
            return annotation;
        }
        return Optional.empty();
    }
}

