/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.testng;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.quality.Strictness;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

public class MockitoTestNGListener
implements IInvokedMethodListener {
    private final Map<Object, MockitoSession> sessions = new WeakHashMap<Object, MockitoSession>();

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.hasMockitoTestNGListenerInTestHierarchy(testResult)) {
            this.sessions.computeIfAbsent(testResult.getInstance(), testInstance -> Mockito.mockitoSession().initMocks(testInstance).strictness(Strictness.STRICT_STUBS).startMocking());
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.hasMockitoTestNGListenerInTestHierarchy(testResult) && method.isTestMethod()) {
            Optional.ofNullable(this.sessions.remove(testResult.getInstance())).ifPresent(mockitoSession -> mockitoSession.finishMocking(testResult.getThrowable()));
        }
    }

    protected boolean hasMockitoTestNGListenerInTestHierarchy(ITestResult testResult) {
        for (Class clazz = testResult.getTestClass().getRealClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!this.hasMockitoTestNGListener(clazz)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasMockitoTestNGListener(Class<?> clazz) {
        Listeners listeners = clazz.getAnnotation(Listeners.class);
        if (listeners == null) {
            return false;
        }
        for (Class listenerClass : listeners.value()) {
            if (this.listenerClass() != listenerClass) continue;
            return true;
        }
        return false;
    }

    protected Class<MockitoTestNGListener> listenerClass() {
        return MockitoTestNGListener.class;
    }
}

