/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.testng.internal;

import java.util.Collection;
import java.util.Map;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.Spy;
import org.mockito.internal.util.reflection.Fields;
import org.testng.IInvokedMethod;
import org.testng.ITestResult;

public class MockitoAfterTestNGMethod {
    private final Map<Object, MockitoSession> sessions;

    public MockitoAfterTestNGMethod(Map<Object, MockitoSession> sessions) {
        this.sessions = sessions;
    }

    public void applyFor(IInvokedMethod method, ITestResult testResult) {
        if (method.isTestMethod()) {
            MockitoSession mockitoSession = this.sessions.get(testResult.getInstance());
            if (mockitoSession != null) {
                mockitoSession.finishMocking(testResult.getThrowable());
            }
            this.resetMocks(testResult.getInstance());
        }
    }

    private void resetMocks(Object instance) {
        Mockito.reset((Object[])this.instanceMocksOf(instance).toArray());
    }

    private Collection<Object> instanceMocksOf(Object instance) {
        return Fields.allDeclaredFieldsOf((Object)instance).filter(Fields.annotatedBy((Class[])new Class[]{Mock.class, Spy.class})).notNull().assignedValues();
    }
}

