/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.testng;

import java.util.Map;
import java.util.WeakHashMap;
import org.mockito.MockitoSession;
import org.mockito.testng.internal.MockitoAfterTestNGMethod;
import org.mockito.testng.internal.MockitoBeforeTestNGMethod;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

public class MockitoTestNGListener
implements IInvokedMethodListener {
    private final Map<Object, MockitoSession> sessions = new WeakHashMap<Object, MockitoSession>();
    private final MockitoBeforeTestNGMethod beforeTest = new MockitoBeforeTestNGMethod(this.sessions);
    private final MockitoAfterTestNGMethod afterTest = new MockitoAfterTestNGMethod(this.sessions);

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.hasMockitoTestNGListenerInTestHierarchy(testResult.getTestClass().getRealClass())) {
            this.beforeTest.applyFor(method, testResult);
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (this.hasMockitoTestNGListenerInTestHierarchy(testResult.getTestClass().getRealClass())) {
            this.afterTest.applyFor(method, testResult);
        }
    }

    protected boolean hasMockitoTestNGListenerInTestHierarchy(Class<?> testClass) {
        for (Class<?> clazz = testClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!this.hasMockitoTestNGListener(clazz)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasMockitoTestNGListener(Class<?> clazz) {
        Listeners listeners = clazz.getAnnotation(Listeners.class);
        if (listeners == null) {
            return false;
        }
        for (Class listenerClass : listeners.value()) {
            if (this.listenerClass() != listenerClass) continue;
            return true;
        }
        return false;
    }

    protected Class<MockitoTestNGListener> listenerClass() {
        return MockitoTestNGListener.class;
    }
}

