/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="MockitoNotExtensible", summary="Some types that are a part of Mockito public API are not intended to be extended.", explanation="Some types that are a part of Mockito public API are not intended to be extended. It's because Mockito team needs to be able to add new methods to some types without breaking compatibility contract. Any type that is not intended to be extended is annotated with @NotExtensible.", severity=BugPattern.SeverityLevel.ERROR)
@AutoService(value={BugChecker.class})
public class MockitoNotExtensible
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getImplementsClause().stream().anyMatch(implementing -> ASTHelpers.hasAnnotation((Symbol)ASTHelpers.getSymbol((Tree)implementing), (String)"org.mockito.NotExtensible", (VisitorState)state))) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

