/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractMockitoAnyForPrimitiveType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    protected abstract Matcher<? super MethodInvocationTree> matcher();

    protected abstract String formatMessage(String var1, Type var2, String var3);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!this.matcher().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Type matcherType = method.getReturnType();
        TreePath path = state.getPath();
        Tree parentTree = path.getParentPath().getLeaf();
        if (!(parentTree instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree parentCall = (MethodInvocationTree)parentTree;
        Symbol.MethodSymbol parentMethod = ASTHelpers.getSymbol((MethodInvocationTree)parentCall);
        int argumentIndex = -1;
        List<? extends ExpressionTree> parentArguments = parentCall.getArguments();
        for (int i = 0; i < parentArguments.size(); ++i) {
            ExpressionTree argumentTree = parentArguments.get(i);
            if (argumentTree != tree) continue;
            argumentIndex = i;
            break;
        }
        if (argumentIndex == -1) {
            throw new IllegalStateException("Cannot find argument " + tree + " in argument list from " + parentTree);
        }
        Type parameterType = this.getParameterType(parentMethod, argumentIndex);
        TypeKind parameterTypeKind = parameterType.getKind();
        if (parameterTypeKind.isPrimitive() && parameterTypeKind != matcherType.getKind()) {
            String replacement;
            String expectedTypeAsString = parameterType.toString();
            String replacementName = "any" + Character.toUpperCase(expectedTypeAsString.charAt(0)) + expectedTypeAsString.substring(1);
            String message = this.formatMessage(expectedTypeAsString, matcherType, replacementName);
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            ExpressionTree methodSelect = tree.getMethodSelect();
            if (methodSelect instanceof MemberSelectTree) {
                MemberSelectTree qualifier = (MemberSelectTree)methodSelect;
                replacement = state.getSourceForNode((Tree)qualifier.getExpression()) + "." + replacementName;
            } else {
                replacement = replacementName;
                String staticImport = method.owner + "." + replacementName;
                fixBuilder.addStaticImport(staticImport);
            }
            SuggestedFix fix = fixBuilder.replace((Tree)tree, replacement + "()").build();
            return this.buildDescription(tree).setMessage(message).addFix((Fix)fix).build();
        }
        return Description.NO_MATCH;
    }

    private Type getParameterType(Symbol.MethodSymbol method, int argumentIndex) {
        TypeMirror parameterType;
        List parameters = method.getParameters();
        int parameterCount = parameters.size();
        if (argumentIndex >= parameterCount && method.isVarArgs()) {
            Symbol.VarSymbol varArgParameter = (Symbol.VarSymbol)parameters.get(parameterCount - 1);
            parameterType = ((Type.ArrayType)varArgParameter.asType()).getComponentType();
        } else {
            parameterType = ((Symbol.VarSymbol)parameters.get(argumentIndex)).asType();
        }
        return parameterType;
    }
}

