/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import org.mockito.errorprone.bugpatterns.AbstractMockitoAnyForPrimitiveType;

@BugPattern(name="MockitoAnyClassWithPrimitiveType", summary="Matcher inconsistency: use of any(Class) to match a primitive argument", severity=BugPattern.SeverityLevel.WARNING, linkType=BugPattern.LinkType.CUSTOM, link="site.mockito.org/usage/bugpattern/MockitoAnyClassWithPrimitiveType", explanation="Mockito relies on Java type checking to ensure that parameter matchers are type safe but there are some discrepancies between what the Java type checker allows and what Mockito expects. e.g. Java will allow anyInt() to be used as a matcher for a long parameter because an int can be widened to a long. This checker highlights those incorrect usages and suggests replacements. In Mockito 1.x this was not really an issue because the anyX() methods did not do runtime type checking of the arguments but in Mockito 2.x they do.")
public class MockitoAnyClassWithPrimitiveType
extends AbstractMockitoAnyForPrimitiveType {
    private static final String[] CLASS_NAMES = new String[]{"org.mockito.Mockito", "org.mockito.ArgumentMatchers", "org.mockito.Matchers"};
    private static final Matcher<ExpressionTree> GENERIC_ANY = Matchers.staticMethod().onClassAny(CLASS_NAMES).named("any");

    @Override
    protected Matcher<? super MethodInvocationTree> matcher() {
        return GENERIC_ANY;
    }

    @Override
    protected String formatMessage(String expectedTypeAsString, Type matcherType, String replacementName) {
        return String.format("Matcher mismatch: use %s() matcher to match primitive %s arguments", replacementName, expectedTypeAsString);
    }
}

