/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern CAPS = Pattern.compile("([A-Z\\d][^A-Z\\d]*)");

    private StringUtil() {
    }

    public static String removeFirstLine(String text) {
        return text.replaceFirst(".*?\n", "");
    }

    public static String join(Object ... linesToBreak) {
        return StringUtil.join("\n", Arrays.asList(linesToBreak));
    }

    public static String join(String start, Iterable<?> lines) {
        StringBuilder out = new StringBuilder(start);
        for (Object line : lines) {
            out.append(line.toString()).append("\n");
        }
        int lastBreak = out.lastIndexOf("\n");
        return out.replace(lastBreak, lastBreak + 1, "").toString();
    }

    public static String decamelizeMatcher(String className) {
        if (className.length() == 0) {
            return "<custom argument matcher>";
        }
        String decamelized = StringUtil.decamelizeClassName(className);
        if (decamelized.length() == 0) {
            return "<" + className + ">";
        }
        return "<" + decamelized + ">";
    }

    private static String decamelizeClassName(String className) {
        Matcher match = CAPS.matcher(className);
        StringBuilder deCameled = new StringBuilder();
        while (match.find()) {
            if (deCameled.length() == 0) {
                deCameled.append(match.group());
                continue;
            }
            deCameled.append(" ");
            deCameled.append(match.group().toLowerCase());
        }
        return deCameled.toString();
    }
}

