/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.instance;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mockito.internal.creation.instance.InstantiationException;
import org.mockito.internal.creation.instance.Instantiator;
import org.mockito.internal.util.StringJoiner;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class ConstructorInstantiator
implements Instantiator {
    private final Object outerClassInstance;

    public ConstructorInstantiator(Object outerClassInstance) {
        this.outerClassInstance = outerClassInstance;
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        if (this.outerClassInstance == null) {
            return ConstructorInstantiator.noArgConstructor(cls);
        }
        return ConstructorInstantiator.withParams(cls, this.outerClassInstance);
    }

    private static <T> T withParams(Class<T> cls, Object ... params) {
        try {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                Class<?>[] types = constructor.getParameterTypes();
                if (!ConstructorInstantiator.paramsMatch(types, params)) continue;
                return ConstructorInstantiator.invokeConstructor(constructor, params);
            }
        }
        catch (Exception e) {
            throw ConstructorInstantiator.paramsException(cls, e);
        }
        throw ConstructorInstantiator.noMatchingConstructor(cls);
    }

    private static <T> T invokeConstructor(Constructor<?> constructor, Object ... params) throws java.lang.InstantiationException, IllegalAccessException, InvocationTargetException {
        AccessibilityChanger accessibility = new AccessibilityChanger();
        accessibility.enableAccess(constructor);
        return (T)constructor.newInstance(params);
    }

    private static <T> InstantiationException paramsException(Class<T> cls, Exception cause) {
        return new InstantiationException(StringJoiner.join("Unable to create instance of '" + cls.getSimpleName() + "'.", "Please ensure that the outer instance has correct type and that the target class has 0-arg constructor."), cause);
    }

    private static <T> InstantiationException noMatchingConstructor(Class<T> cls) {
        return new InstantiationException(StringJoiner.join("Unable to create instance of '" + cls.getSimpleName() + "'.", "Unable to find a matching 1-arg constructor for the outer instance."), null);
    }

    private static boolean paramsMatch(Class<?>[] types, Object[] params) {
        if (params.length != types.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (types[i].isInstance(params[i])) continue;
            return false;
        }
        return true;
    }

    private static <T> T noArgConstructor(Class<T> cls) {
        try {
            return ConstructorInstantiator.invokeConstructor(cls.getDeclaredConstructor(new Class[0]), new Object[0]);
        }
        catch (Throwable t) {
            throw new InstantiationException(StringJoiner.join("Unable to create instance of '" + cls.getSimpleName() + "'.", "Please ensure it has 0-arg constructor which invokes cleanly."), t);
        }
    }
}

