/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","1d13f51538d0e21d9d45c52022039e24"],["allclasses-noframe.html","b0a83e30947077bb9dc2de26f550fb20"],["constant-values.html","f16995d43d93385399a06175db72df2f"],["deprecated-list.html","64ebbf1a4a879f06f78ba1cd3a57e81b"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","2c14d835abaf0457ded822cbed555f3a"],["index-files/index-1.html","34050d4f0064071c449a1d68634eef52"],["index-files/index-10.html","d902e4ccb96c83d9167aa10ad9dcd25f"],["index-files/index-11.html","f1d030a95143e2a4d7b531f1d0d6d20b"],["index-files/index-12.html","58ca79762a301355d23dd7d51c9fa20c"],["index-files/index-13.html","8997ffebd8c0de1ba3ac08b8fc424387"],["index-files/index-14.html","58f819edb977855db5359c5251b70e98"],["index-files/index-15.html","fabd56834698c3d57c326f2834cf68cf"],["index-files/index-16.html","8d3a0dc3650b85d10ba5c3b4fc88278a"],["index-files/index-17.html","2982368a4690214bb7e99c57b7c366fa"],["index-files/index-18.html","34b0619e02953440a189bf557d631c0c"],["index-files/index-19.html","8504d60f59179db7468dc09d8a1e2993"],["index-files/index-2.html","d6f30a3ff05d5eda5fe0738a480c2a66"],["index-files/index-20.html","141a7a75cc23338cf8de650e9279d568"],["index-files/index-3.html","6413410d1e8ac7c3f480a04f6dce426e"],["index-files/index-4.html","00240c2b30aeec49b9ad7775382260bb"],["index-files/index-5.html","626df0aa3a48ec8004293654e20cb5bf"],["index-files/index-6.html","2caf28559a49d2a030c476e324bedd16"],["index-files/index-7.html","d80afb82bdc63a834a21eafe4cba3332"],["index-files/index-8.html","177fe67227e42c39d921fb4b33ea6ba1"],["index-files/index-9.html","028b93a7584f53bbc32c0d6ad87903fa"],["index.html","c5a199e9ccda08235796582b609eeb13"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","96d48bb22fec625681ee72477ad864cf"],["org/mockito/AdditionalMatchers.html","02913fd5e63ad3cd921ae882cb811aa0"],["org/mockito/Answers.html","6085e5a2755c799f23a4c4a0d62f2a11"],["org/mockito/ArgumentCaptor.html","890a02af19954fb2a4558a17717d5361"],["org/mockito/ArgumentMatcher.html","bfabedc1e6ddfe6ca9f8ed5ee90aa1cd"],["org/mockito/ArgumentMatchers.html","645a2d8ec6e87da6d63080cae0d5cde4"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","8d9a2c1e15bc5ae4584b1cc748055ae7"],["org/mockito/BDDMockito.BDDStubber.html","7fc84f2d73cb4dde9165306ffdb5bfc0"],["org/mockito/BDDMockito.Then.html","d3250c8718d920203337013dea53c5a7"],["org/mockito/BDDMockito.html","7978daeec39325100c82184daaba520a"],["org/mockito/Captor.html","62f671e7e23ff8debf15eda50c505b62"],["org/mockito/InOrder.html","d3de5a4c793358db4f50f93cae253784"],["org/mockito/Incubating.html","3268088d6465f1014de39ced790379e0"],["org/mockito/InjectMocks.html","feb866e36fc662b5728af9d92865d8d7"],["org/mockito/Matchers.html","7be847c3b3f25f21e6f344cdecad344e"],["org/mockito/Mock.html","2088e29de386f770246778af80919220"],["org/mockito/MockSettings.html","55d5863a39b36c999175d53738b2ce03"],["org/mockito/MockingDetails.html","a974de9fd871b2e3754094a3dcd6a3f8"],["org/mockito/Mockito.html","30ffa2138eecc8a9fa604512462f8e3b"],["org/mockito/MockitoAnnotations.html","abbde82e4e5eff8a15436c8384185451"],["org/mockito/MockitoDebugger.html","d182604f201064000f98347d6b9fab05"],["org/mockito/MockitoFramework.html","97eb63a9b919d616a840e037b97ccc66"],["org/mockito/Spy.html","2666f24cdcc2d47be00e54d4bfab12f8"],["org/mockito/class-use/AdditionalAnswers.html","a4c5ee9f89d1c5cbe8c28d50099d6145"],["org/mockito/class-use/AdditionalMatchers.html","90e258015ae27c82225fc6a4565afd4e"],["org/mockito/class-use/Answers.html","5ea63a2a95c1a814ae6e18987f98d508"],["org/mockito/class-use/ArgumentCaptor.html","faa901ab1e1ce09862b25abcd1c41ca9"],["org/mockito/class-use/ArgumentMatcher.html","5ac81a47624271332b092ff2b4c94f22"],["org/mockito/class-use/ArgumentMatchers.html","0885387d65e89e78521c450a889d3fc0"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","f40b39f8bbf7b37143beb6fe5d9f3ea1"],["org/mockito/class-use/BDDMockito.BDDStubber.html","4961fb6a00774841f4d45ad29fb255f8"],["org/mockito/class-use/BDDMockito.Then.html","305927542afb036b14d5e00ab84b6395"],["org/mockito/class-use/BDDMockito.html","2e7dbffa13667d22cff7c82d874de887"],["org/mockito/class-use/Captor.html","b4f122aeb9b3ecbb3adb7775d65cd8f3"],["org/mockito/class-use/InOrder.html","c819611c5fc6bff32826f72dff651e13"],["org/mockito/class-use/Incubating.html","f5318297f2c3402dbbe427a2f0273597"],["org/mockito/class-use/InjectMocks.html","010018f9600d254ae08560822725cda2"],["org/mockito/class-use/Matchers.html","252847b4983e5bec721b3ca6218caa81"],["org/mockito/class-use/Mock.html","45ce2451aa1a961530a86e4cd2020dbf"],["org/mockito/class-use/MockSettings.html","014643792515dcf2271c1248952f34e1"],["org/mockito/class-use/MockingDetails.html","b05c99a2c906acaa067ec1a45927cd59"],["org/mockito/class-use/Mockito.html","0735418e830003f99745321c691954c5"],["org/mockito/class-use/MockitoAnnotations.html","e8a109bf0fd8931ceaa9b7e5d8e796ce"],["org/mockito/class-use/MockitoDebugger.html","87966094617a7d0da191a2d58a7b7877"],["org/mockito/class-use/MockitoFramework.html","0b84acbd7d64f914bdf1aa752342e0fc"],["org/mockito/class-use/Spy.html","8ebcb53490cc5232657e55960c4c55c8"],["org/mockito/configuration/AnnotationEngine.html","a39547e5dbcb8dadb92f19debd72eba6"],["org/mockito/configuration/DefaultMockitoConfiguration.html","0b2b4bf8eac30370604dab73493ee85b"],["org/mockito/configuration/IMockitoConfiguration.html","5cced53a20fc3fb1a780fd43c7cebe4f"],["org/mockito/configuration/class-use/AnnotationEngine.html","88b5d14d96554cc0cd85c68f59dc7198"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","2df6e40a1f02d1814c49b476b07da211"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","22cd70f6432927279d1b106f24968c26"],["org/mockito/configuration/package-frame.html","07c6507088c75fa4c5a9e2d71f8dc617"],["org/mockito/configuration/package-summary.html","f2d03e283dee8f02cb3f1987a744b4c7"],["org/mockito/configuration/package-tree.html","907034249eb0fc0811d5e2ca1c33b430"],["org/mockito/configuration/package-use.html","7bd98fd711e7f3d74abe9577fe1e4744"],["org/mockito/exceptions/base/MockitoAssertionError.html","2dfa187c3fb97454816169bbc802c64d"],["org/mockito/exceptions/base/MockitoException.html","f69a121173e3f31b4d1d7ae90213c84f"],["org/mockito/exceptions/base/MockitoInitializationException.html","051682c3f38fe81503d1d7a2682ea64e"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","345a13c72087d5e60d64f23676cbe720"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","f4491549cef8be876c0eefb7b7039f2b"],["org/mockito/exceptions/base/class-use/MockitoException.html","be6258f3a92d5501d0ec595bb6ca50f9"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","2dc470c6f162d8f30f362a491b80ab2c"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","32e37c5c19f7da2c2ffff13370515071"],["org/mockito/exceptions/base/package-frame.html","0a32b1d3e620997f857aa5684650f664"],["org/mockito/exceptions/base/package-summary.html","cb610a01db1f3ad89d33807afb3e86f7"],["org/mockito/exceptions/base/package-tree.html","22d891ff8d8237a05e8b02396f934f58"],["org/mockito/exceptions/base/package-use.html","dd7c9b9b3c0d07477a8dc272ed493b8e"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","644919eb89b387b9766bf023ce459e80"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","9fbdb4f3e18a4746d567b48b46f1f41d"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","248c7f38b164906f774bfe1e71b5cf95"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","221021ae858b1c72664aad71ec894571"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","b70a2e6cb66fbeb34ca598a9bc8e5af3"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","d503e6b94478e013eb37100f0121db60"],["org/mockito/exceptions/misusing/NotAMockException.html","81cc3bea21027d1d1fc1a22fd0d37ede"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","10eb37779bcc27f7c2a09712ab6d574a"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","897a36bb58bd2ec82084a7d944ab5f25"],["org/mockito/exceptions/misusing/RedundantListenerException.html","2b23dc071746f953a5b9f0894ebc2c7a"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","053f52ed4fffc7b8047c4682adaf2176"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","69a4944bab700c4b92cd8c74ecbd165d"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","e7b3f674e946ca6f5d386e0a1dbbd2e3"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","6b6c18df332c6fcb937bdc8bc1217bc2"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","301abd6cd5453e3af6aa82587a157977"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","0288a353a1dc9cbc6062426f414be9b7"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","5be40e2fe093ddea30faca9741bb1f2d"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","a1aaece5afe58e9efe22411d42b42b1f"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","3d29b889fb777f5ad75a7a5623e1cbdc"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","c71b8e40100eb91b37ba9710d145bc27"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","d4a42b1b25d241a9572d61c33144a19e"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","273bd197e99664fa881205e71c7639f4"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","11de4bf90650fea04c8f80ac089078a8"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","650ff9460e5b10be5ea0132c5df7660c"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","92de68c9cdd099f4ee13698adc77bd10"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","b0234dcc3609109775efc814abcf84c2"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","1df3738d99a7d5184176022b9a509fc4"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","6ac4eba3b347a0a4cf2ed067283878a5"],["org/mockito/exceptions/misusing/package-frame.html","675d8475c230cf52ad2ea383bbd24038"],["org/mockito/exceptions/misusing/package-summary.html","b77732596d9e7246a5d2519c95757b4a"],["org/mockito/exceptions/misusing/package-tree.html","0f665cbfa6f6f8f069082f212d036ba5"],["org/mockito/exceptions/misusing/package-use.html","f92009260f6c44f3ef09fbcd84c470ca"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","d5d9a63c84aaefb4b0f8a8f48e0517ce"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","bf6b5a6517561684b909baae36b10109"],["org/mockito/exceptions/stacktrace/package-frame.html","ade1fab7a517e3ee74d8947114c42e8e"],["org/mockito/exceptions/stacktrace/package-summary.html","4308cc5c06b82f196bcfb2cbfb056626"],["org/mockito/exceptions/stacktrace/package-tree.html","b32f1e32578cefc3209aa972000163e9"],["org/mockito/exceptions/stacktrace/package-use.html","1b6ee9ed758a3b2c95a84f7a13480d77"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","5c661d931bbf4cfcbb41e781e588a2da"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","b86f25ee364c98624fb293a129ca5926"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","3ad4309e212911ff5369d5df500ad40b"],["org/mockito/exceptions/verification/SmartNullPointerException.html","141d669d7e829d60c4c953654dd0ec97"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","a1500440635ee5c776827e35be670333"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","27f359f75dd90dffda566244ed1e61f3"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","9e0937e3dd4b90fde67d5492eddd12fc"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","563817c933b71468a10f3a4f55d3a9b2"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","175d81521fb832a397dd627be98e32f2"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","3608ed968e145d387e68aee207e19c53"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","feb25637c242f3476cf1a1875f1199b3"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","73e8be128751d5c69cb635fa4dd830d7"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","af2632171cdd9bbab488defaf03a994d"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","2c5daa716d3f5d323c1316566cc2dcfc"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","416af15ca25728fc4aa9b64cb4c823c9"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","cd5d126c1ae94e36702132d89ce02c94"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","cc71b63399e6cac538f8321f5aff9d6d"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","6b543fae196663baafe834d54095509c"],["org/mockito/exceptions/verification/junit/package-frame.html","8f006b0c4ee94a0ad20b95b9fa595da3"],["org/mockito/exceptions/verification/junit/package-summary.html","e2bb5bc9dbce2b163bf1ccf3bfb2f49b"],["org/mockito/exceptions/verification/junit/package-tree.html","aac1c2ef4f87584d869daaa85ec0ac0e"],["org/mockito/exceptions/verification/junit/package-use.html","c91d14a1099c7accc76dc3cfd6181258"],["org/mockito/exceptions/verification/package-frame.html","94c336625666ac1462d9784461c9b1dd"],["org/mockito/exceptions/verification/package-summary.html","d3518467f7c1d4977fa6a429a429c311"],["org/mockito/exceptions/verification/package-tree.html","4a5015075ebc4bb29e52eb90ce776c4f"],["org/mockito/exceptions/verification/package-use.html","62271dda72681877ded0f0e114860816"],["org/mockito/hamcrest/MockitoHamcrest.html","2074325c3da888942d3adf4131d774b4"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","4a8a94138847f1f3c58e02ed96195461"],["org/mockito/hamcrest/package-frame.html","b030b443c9915c13d913a1c44dd46e2d"],["org/mockito/hamcrest/package-summary.html","36d6f1d088db5b93226e93bcd4ca8623"],["org/mockito/hamcrest/package-tree.html","613e0ea11661715fc26eac75f5635e45"],["org/mockito/hamcrest/package-use.html","374e372df762124333020de72cba2098"],["org/mockito/invocation/DescribedInvocation.html","3eb81b6499c7c5e6a17cdb99eb103f8d"],["org/mockito/invocation/Invocation.html","fea6b27168c9d4d7874241a7b1224ee5"],["org/mockito/invocation/InvocationOnMock.html","5413fe5028aedd29f1fabdd050854830"],["org/mockito/invocation/Location.html","9d44f61834b8e05d2c0191a6be44cd16"],["org/mockito/invocation/MatchableInvocation.html","ec35289effa558cef61e2ca4976f207a"],["org/mockito/invocation/MockHandler.html","3631a78dbe5b5cb64afcdc4fa629c899"],["org/mockito/invocation/StubInfo.html","665b251907e82035a1429b9e5f55d004"],["org/mockito/invocation/class-use/DescribedInvocation.html","f11589bb66bc362b12e21f288dd3c0e0"],["org/mockito/invocation/class-use/Invocation.html","c509eb69d2716cdbf06626b3d54c5694"],["org/mockito/invocation/class-use/InvocationOnMock.html","57b324a32afd25eb5055f5b491be44c3"],["org/mockito/invocation/class-use/Location.html","72d7ae00a6af716baeb7f5c98bc629ef"],["org/mockito/invocation/class-use/MatchableInvocation.html","d35544fb9026dd6eed0e376b3df0b9c7"],["org/mockito/invocation/class-use/MockHandler.html","19920df4ea3430cbe3778964db166206"],["org/mockito/invocation/class-use/StubInfo.html","35b7cfaff1aa241bf942486e7227f00e"],["org/mockito/invocation/package-frame.html","0c7bf4cc5175455fd05c4aaf649f2fef"],["org/mockito/invocation/package-summary.html","a15dbe3d628718f1a0ef626b0daf1357"],["org/mockito/invocation/package-tree.html","bd29b69981ea7459628ac71e59b8e416"],["org/mockito/invocation/package-use.html","73cd3277d6b5e7a6430905755cf60864"],["org/mockito/junit/MockitoJUnit.html","0396c54a1475fdca19f9ae3d63b31a20"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","3625d0d5da80457258693f8b4d68aa37"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","bfb641b4546e73fe03995d39184a6c2d"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","94138499cbab13883f707924222a2372"],["org/mockito/junit/MockitoJUnitRunner.html","223fe8a30c61657ca0840d353831f7dd"],["org/mockito/junit/MockitoRule.html","179547490aff565f045ed6cf7b83e6b6"],["org/mockito/junit/VerificationCollector.html","1042761796f4a44d08a39570dadb5131"],["org/mockito/junit/class-use/MockitoJUnit.html","c7dd17baa5cc55913e57576deabb03e7"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","404c567f2f658f4838ef76fa30b95b0c"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","aeb48bbc6329bfdafcb903ed96240dd4"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","7eb3797cc54ee7e39f8913bc472dad01"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","46775d03128f573c57457abe0aaa1196"],["org/mockito/junit/class-use/MockitoRule.html","b875aa0c6239555da3c394cd9f45a88c"],["org/mockito/junit/class-use/VerificationCollector.html","c2d826b1ca9de0c3670b0d56225a50e5"],["org/mockito/junit/package-frame.html","73c8bf1bfb38bfe2dbd32bdf36fd08ec"],["org/mockito/junit/package-summary.html","705843f02220be7683ff1b4be6ba58d5"],["org/mockito/junit/package-tree.html","dfcc4a2ea06dbc8a366f3229c09eb949"],["org/mockito/junit/package-use.html","b5db13c7ec5bb6cfa4864709f85116af"],["org/mockito/listeners/InvocationListener.html","2bf46b8f0a85596583ed6e3fb51b3311"],["org/mockito/listeners/MethodInvocationReport.html","759b5dc8ffa580b82fc21a74ae6d0509"],["org/mockito/listeners/MockCreationListener.html","b46347a02f3aa600fdd61f9a7215b196"],["org/mockito/listeners/MockitoListener.html","34fc916d64839c6cd6101067f53c9a61"],["org/mockito/listeners/VerificationListener.html","ace433d7c162840607290bcb74af0fb8"],["org/mockito/listeners/class-use/InvocationListener.html","1d08c4dc504b9c3f5463c46aeea8403e"],["org/mockito/listeners/class-use/MethodInvocationReport.html","3ed949e96cc8d82df19f50fc549e6157"],["org/mockito/listeners/class-use/MockCreationListener.html","882544d0b44edc5158eb7cf6970b225c"],["org/mockito/listeners/class-use/MockitoListener.html","592f32e5ac0312dd38bd813ef1645963"],["org/mockito/listeners/class-use/VerificationListener.html","f3f51467e7e635d12c5dedf2562040c5"],["org/mockito/listeners/package-frame.html","729737af5caf280066fc265f7ee83b6f"],["org/mockito/listeners/package-summary.html","bb66a285f7e0f14aeeeec0e042b9a551"],["org/mockito/listeners/package-tree.html","2f4144978768e31156b9e8faefb19400"],["org/mockito/listeners/package-use.html","7a81fa998432b281574a85a0f98cf120"],["org/mockito/mock/MockCreationSettings.html","a9be587687cd3d1fe13bf504348fef85"],["org/mockito/mock/MockName.html","f5fe093fc6ce534549f7feb1f704a79b"],["org/mockito/mock/SerializableMode.html","dbf93b75427468617625ede1dcab4bf4"],["org/mockito/mock/class-use/MockCreationSettings.html","eb3d14411e99d410e5daf57a283e84ae"],["org/mockito/mock/class-use/MockName.html","8da65e93004be5a11ee47f9a56e90a40"],["org/mockito/mock/class-use/SerializableMode.html","55660c6ddd8479bb376f90e3bba7e1de"],["org/mockito/mock/package-frame.html","abdd0d8833c7655c409f058e7bb4111a"],["org/mockito/mock/package-summary.html","bdce50d22e6c7882094c7f387aa62bb3"],["org/mockito/mock/package-tree.html","7db89e7d5ddefddcb3bc76ff1f3a7aa7"],["org/mockito/mock/package-use.html","c5df7fd223a88b1d562ff2fd14136189"],["org/mockito/package-frame.html","b427b2f47e0313406fc25b3eccd29773"],["org/mockito/package-summary.html","e1e067556692e722990556d2498885e4"],["org/mockito/package-tree.html","94df3d56eb9292b49001ce18b80f2121"],["org/mockito/package-use.html","dc8a9f29ae3b44837ecbdc43b7ac5fb3"],["org/mockito/plugins/AnnotationEngine.html","c3399da12c2bc43140a704831b9bfd68"],["org/mockito/plugins/InstantiatorProvider.html","428017511d860de61fb6494f4805f10f"],["org/mockito/plugins/MockMaker.TypeMockability.html","1deb9d8849360fc44136489b6337ce7d"],["org/mockito/plugins/MockMaker.html","d66b393d68155ceb80e3e10a9eb86490"],["org/mockito/plugins/PluginSwitch.html","6965111475710896b50d4e791c00bbb9"],["org/mockito/plugins/StackTraceCleanerProvider.html","1f3f7a63a9dfd8e4f8278ad67313e3d7"],["org/mockito/plugins/class-use/AnnotationEngine.html","97c2a4974ad080de55590a52311c83e7"],["org/mockito/plugins/class-use/InstantiatorProvider.html","4cb3b29d88396876fa008a3e7c13248f"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","e9c4b764c743f24263e80f635b3dcf50"],["org/mockito/plugins/class-use/MockMaker.html","ac64ba3367eee6a1fb788791e149ced8"],["org/mockito/plugins/class-use/PluginSwitch.html","d3d2039d45bd55fb56299f4bbdc5ad07"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","467391e5dcf3b0e1b7cb74aa4a308f59"],["org/mockito/plugins/package-frame.html","0ac403b8f1024ef7867a7ff74369f35b"],["org/mockito/plugins/package-summary.html","c5e4d116d9bbd066b437dda70cf84b08"],["org/mockito/plugins/package-tree.html","67240c69981d56c1f77590ef3b6b6d7d"],["org/mockito/plugins/package-use.html","76ed3de55ef881721dc2742872d08b22"],["org/mockito/quality/MockitoHint.html","6a483e3ebc442393f0a80b4116594f3a"],["org/mockito/quality/Strictness.html","87eb2f04ba227cd60c5d78befbdb2748"],["org/mockito/quality/class-use/MockitoHint.html","b16d3a3253b735f5d0a7ed7c36432261"],["org/mockito/quality/class-use/Strictness.html","29adfd5875843ac8a3aa9295d93c981f"],["org/mockito/quality/package-frame.html","309f60635757675b1c829083c5c37cad"],["org/mockito/quality/package-summary.html","0493a51f9609135539e03c22ad417c23"],["org/mockito/quality/package-tree.html","9b12cbf32d3d782d060d0d07d40bab2f"],["org/mockito/quality/package-use.html","44a50bea7fce15b9606bdd82546a637b"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","60f66af83fdc2d8eff22832c5c84f6c6"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","df9ab54c11ee45679054f33b0ba6cd85"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","2672a69e33595576350947ca0b5a2781"],["org/mockito/runners/MockitoJUnitRunner.html","7c81d4d6ea5f0dc2ff254c800beed095"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","34d832a0efd65eb68f15349ab13f7174"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","40f0275531c30ecfcae88ea8862babe2"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","1ed45cadc13d47cf7252660dac25aac8"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","703350eb974e341becbc92aee2bb6329"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","a08d3b4c3f2e475d66e58952b1b89d94"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","3aec3aea765655076cb5b756edf9f603"],["org/mockito/runners/package-frame.html","59b7b1669d4e7cda96d7d4400d0f425e"],["org/mockito/runners/package-summary.html","08023fe759aacae20df8d8f525c278e1"],["org/mockito/runners/package-tree.html","42861b71e0db412a090d107ab57166ac"],["org/mockito/runners/package-use.html","ce074ede13383ae3c6ba2bf4e5000f48"],["org/mockito/stubbing/Answer.html","64b9b32d6388aa8825172e6876cb3f62"],["org/mockito/stubbing/Answer1.html","c5a96d574e3ca0c3e3ecdb89167e4fbb"],["org/mockito/stubbing/Answer2.html","22eccee6500a3320eedee3b0322a726a"],["org/mockito/stubbing/Answer3.html","71cb486752c6ee2ae09fdd2fe4a95a25"],["org/mockito/stubbing/Answer4.html","9057e5610aec50d4fcb0d7f20b947317"],["org/mockito/stubbing/Answer5.html","a3721b14a3cd2b959ab6d9cd84f314ad"],["org/mockito/stubbing/OngoingStubbing.html","74487e5dc032a062c30533f39140ffa4"],["org/mockito/stubbing/Stubber.html","c13ed3d8fb050496844d5ad363284be0"],["org/mockito/stubbing/Stubbing.html","de94c57a9ae75232e2d0798bdd542a9c"],["org/mockito/stubbing/ValidableAnswer.html","d1ef2752382a964e9c9e88c5896587d1"],["org/mockito/stubbing/VoidAnswer1.html","390ba27e3c8e455fbef323e7a66e46ba"],["org/mockito/stubbing/VoidAnswer2.html","bfbe491fe7d37f6028d47e93919143ef"],["org/mockito/stubbing/VoidAnswer3.html","d6ef808c809cdc1ad4e4baf50ea78476"],["org/mockito/stubbing/VoidAnswer4.html","2e722be25859adb1eaaf181983298a89"],["org/mockito/stubbing/VoidAnswer5.html","bc1a199b816a6cedb32b17a254007510"],["org/mockito/stubbing/class-use/Answer.html","80bfa64efe4971632621be7386f9e579"],["org/mockito/stubbing/class-use/Answer1.html","374165bec0675fd46e10ad556a258524"],["org/mockito/stubbing/class-use/Answer2.html","f220ec1f171b2aed3757af68dd448675"],["org/mockito/stubbing/class-use/Answer3.html","50ffff6154e2584a6c74a57d1d53b13a"],["org/mockito/stubbing/class-use/Answer4.html","b15ea2e9d65c129d77425e05e5afbe34"],["org/mockito/stubbing/class-use/Answer5.html","addbbbfb4b965dec86110970a085d921"],["org/mockito/stubbing/class-use/OngoingStubbing.html","13de94878d5dc40c28743aa56e728286"],["org/mockito/stubbing/class-use/Stubber.html","69aa18eaf9e63fafd5c302161ab25f23"],["org/mockito/stubbing/class-use/Stubbing.html","39fa29379d4777e6f3ddf4e5ea6aae1f"],["org/mockito/stubbing/class-use/ValidableAnswer.html","ec7959ca6f206fa66a3f8be3df22c8d4"],["org/mockito/stubbing/class-use/VoidAnswer1.html","686a80bf7661764f9efebd1ca59b7075"],["org/mockito/stubbing/class-use/VoidAnswer2.html","1530e32e1bb8993d6ce6e2e121530485"],["org/mockito/stubbing/class-use/VoidAnswer3.html","9e0075048e1e0466c83cc877fe1728e0"],["org/mockito/stubbing/class-use/VoidAnswer4.html","198b6ef88251d9ae041e247476f8c4ab"],["org/mockito/stubbing/class-use/VoidAnswer5.html","c0100b373e7ff2f0adafda0ce56d7170"],["org/mockito/stubbing/package-frame.html","fb8a749fc1ae414c97b99f79a43001df"],["org/mockito/stubbing/package-summary.html","33614e7bcc7b29b38a0c0e805205eebc"],["org/mockito/stubbing/package-tree.html","43ee1e81450cd9bf57095a25fed13283"],["org/mockito/stubbing/package-use.html","e0bcd1f4eabe4ac922777b0aecf22702"],["org/mockito/verification/After.html","26490a4a37f04e92e77a7d5d9c4621d7"],["org/mockito/verification/Timeout.html","9145ea2f0ee25d834ae73692b1079e8b"],["org/mockito/verification/VerificationAfterDelay.html","19a84d381658c1acc7d3224e03611ea3"],["org/mockito/verification/VerificationEvent.html","b20388b871f2a65465e0438d86ad84f2"],["org/mockito/verification/VerificationMode.html","3dcd3d9130b021e5679e0301bf5b6550"],["org/mockito/verification/VerificationStrategy.html","bc3289f44455fd90535e5410aad602e8"],["org/mockito/verification/VerificationWithTimeout.html","3962026bd8e3874fe07b8452675800ee"],["org/mockito/verification/class-use/After.html","6b63ea81a40ad7cf3c391b08477a6a95"],["org/mockito/verification/class-use/Timeout.html","117acb3def5af4d0eba6a05bdcc2f48e"],["org/mockito/verification/class-use/VerificationAfterDelay.html","b425730bc6b99e45319a93b6f6944292"],["org/mockito/verification/class-use/VerificationEvent.html","35846871bb75391ac816dbb2b5a4a354"],["org/mockito/verification/class-use/VerificationMode.html","0f4f3353272f554400e49855d86b704b"],["org/mockito/verification/class-use/VerificationStrategy.html","ba723b0c08335018c8427b37e52531b3"],["org/mockito/verification/class-use/VerificationWithTimeout.html","002b7ef00149274650cb57b7c2f60482"],["org/mockito/verification/package-frame.html","b2644e4c0fa29861290ec50aaeeaffe4"],["org/mockito/verification/package-summary.html","76720db6e345b22b855fbb5e2b649219"],["org/mockito/verification/package-tree.html","80293b2df519ebeb5930d818d25f425b"],["org/mockito/verification/package-use.html","60b6c9d6b17d979cea037f946d120150"],["overview-frame.html","bcd260fef748c504e902f7b340933225"],["overview-summary.html","5769a6399649162544c142f85ccf4b27"],["overview-tree.html","69ea0dcada0c0154e202b6e0fa84404d"],["serialized-form.html","fbff8e998cb342a9bbcaed869f376347"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v2-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {
                credentials: 'same-origin',
                redirect: 'follow'
              }));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







