/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.Discrepancy;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MatchableInvocation;

public class NonGreedyNumberOfInvocationsInOrderChecker {
    private NonGreedyNumberOfInvocationsInOrderChecker() {
    }

    public static void check(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount, InOrderContext context) {
        Location lastLocation = null;
        for (int actualCount = 0; actualCount < wantedCount; ++actualCount) {
            Invocation next = InvocationsFinder.findFirstMatchingUnverifiedInvocation(invocations, wanted, context);
            if (next == null) {
                throw Reporter.tooLittleActualInvocationsInOrder(new Discrepancy(wantedCount, actualCount), wanted, lastLocation);
            }
            InvocationMarker.markVerified(next, wanted);
            context.markVerified(next);
            lastLocation = next.getLocation();
        }
    }
}

