/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.Discrepancy;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MatchableInvocation;

public class NumberOfInvocationsInOrderChecker {
    public void check(List<Invocation> invocations, MatchableInvocation wanted, int wantedCount, InOrderContext context) {
        List<Invocation> chunk = InvocationsFinder.findMatchingChunk(invocations, wanted, wantedCount, context);
        int actualCount = chunk.size();
        if (wantedCount > actualCount) {
            Location lastInvocation = InvocationsFinder.getLastLocation(chunk);
            throw Reporter.tooLittleActualInvocationsInOrder(new Discrepancy(wantedCount, actualCount), wanted, lastInvocation);
        }
        if (wantedCount < actualCount) {
            Location firstUndesired = chunk.get(wantedCount).getLocation();
            throw Reporter.tooManyActualInvocationsInOrder(wantedCount, actualCount, wanted, firstUndesired);
        }
        InvocationMarker.markVerifiedInOrder(chunk, wanted, context);
    }
}

