/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Random;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SynchronizationState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mockito.internal.creation.bytebuddy.ByteBuddyCrossClassLoaderSerializationSupport;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.creation.bytebuddy.SubclassInjectionLoader;
import org.mockito.internal.creation.bytebuddy.SubclassLoader;
import org.mockito.mock.SerializableMode;

class SubclassBytecodeGenerator
implements BytecodeGenerator {
    private final SubclassLoader loader;
    private final ByteBuddy byteBuddy;
    private final Random random;
    private final Implementation readReplace;
    private final ElementMatcher<? super MethodDescription> matcher;

    public SubclassBytecodeGenerator() {
        this(new SubclassInjectionLoader());
    }

    public SubclassBytecodeGenerator(SubclassLoader loader) {
        this(loader, null, (ElementMatcher<? super MethodDescription>)ElementMatchers.any());
    }

    public SubclassBytecodeGenerator(Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this(new SubclassInjectionLoader(), readReplace, matcher);
    }

    protected SubclassBytecodeGenerator(SubclassLoader loader, Implementation readReplace, ElementMatcher<? super MethodDescription> matcher) {
        this.loader = loader;
        this.readReplace = readReplace;
        this.matcher = matcher;
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED);
        this.random = new Random();
    }

    @Override
    public <T> Class<? extends T> mockClass(MockFeatures<T> features) {
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = this.byteBuddy.subclass(features.mockedType).name(this.nameFor(features.mockedType)).ignoreAlso(SubclassBytecodeGenerator.isGroovyMethod()).annotateType(features.mockedType.getAnnotations()).implement(new ArrayList(features.interfaces)).method(this.matcher).intercept((Implementation)MethodDelegation.to(MockMethodInterceptor.DispatcherDefaultingToRealMethod.class)).transform(Transformer.ForMethod.withModifiers((ModifierContributor.ForMethod[])new ModifierContributor.ForMethod[]{SynchronizationState.PLAIN, Visibility.PUBLIC})).attribute((MethodAttributeAppender.Factory)MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER).method((ElementMatcher)ElementMatchers.isHashCode()).intercept((Implementation)MethodDelegation.to(MockMethodInterceptor.ForHashCode.class)).method((ElementMatcher)ElementMatchers.isEquals()).intercept((Implementation)MethodDelegation.to(MockMethodInterceptor.ForEquals.class)).serialVersionUid(42L).defineField("mockitoInterceptor", MockMethodInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).implement(new Type[]{MockAccess.class}).intercept((Implementation)FieldAccessor.ofBeanProperty());
        if (features.serializableMode == SerializableMode.ACROSS_CLASSLOADERS) {
            builder = builder.implement(new Type[]{ByteBuddyCrossClassLoaderSerializationSupport.CrossClassLoaderSerializableMock.class}).intercept((Implementation)MethodDelegation.to(MockMethodInterceptor.ForWriteReplace.class));
        }
        if (this.readReplace != null) {
            builder = builder.defineMethod("readObject", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).withParameters(new Type[]{ObjectInputStream.class}).throwing(new Type[]{ClassNotFoundException.class, IOException.class}).intercept(this.readReplace);
        }
        return builder.make().load(new MultipleParentClassLoader.Builder().append(new Class[]{features.mockedType}).append(features.interfaces).append(new ClassLoader[]{Thread.currentThread().getContextClassLoader()}).append(new Class[]{MockAccess.class, MockMethodInterceptor.DispatcherDefaultingToRealMethod.class}).append(new Class[]{MockMethodInterceptor.class, MockMethodInterceptor.ForHashCode.class, MockMethodInterceptor.ForEquals.class}).build(MockMethodInterceptor.class.getClassLoader()), this.loader.getStrategy(features.mockedType)).getLoaded();
    }

    private static ElementMatcher<MethodDescription> isGroovyMethod() {
        return ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.named((String)"groovy.lang.GroovyObjectSupport"));
    }

    private String nameFor(Class<?> type) {
        String typeName = type.getName();
        if (this.isComingFromJDK(type) || this.isComingFromSignedJar(type) || this.isComingFromSealedPackage(type)) {
            typeName = "codegen." + typeName;
        }
        return String.format("%s$%s$%d", typeName, "MockitoMock", Math.abs(this.random.nextInt()));
    }

    private boolean isComingFromJDK(Class<?> type) {
        return type.getPackage() != null && "Java Runtime Environment".equalsIgnoreCase(type.getPackage().getImplementationTitle()) || type.getName().startsWith("java.") || type.getName().startsWith("javax.");
    }

    private boolean isComingFromSealedPackage(Class<?> type) {
        return type.getPackage() != null && type.getPackage().isSealed();
    }

    private boolean isComingFromSignedJar(Class<?> type) {
        return type.getSigners() != null;
    }
}

