/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.answers;

import java.io.Serializable;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.internal.stubbing.answers.InvocationInfo;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.ValidableAnswer;

public class ThrowsException
implements Answer<Object>,
ValidableAnswer,
Serializable {
    private static final long serialVersionUID = 1128820328555183980L;
    private final Throwable throwable;
    private final ConditionalStackTraceFilter filter = new ConditionalStackTraceFilter();

    public ThrowsException(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        if (MockUtil.isMock(this.throwable)) {
            throw this.throwable;
        }
        Throwable t = this.throwable.fillInStackTrace();
        this.filter.filter(t);
        throw t;
    }

    @Override
    public void validateFor(InvocationOnMock invocation) {
        if (this.throwable == null) {
            throw Reporter.cannotStubWithNullThrowable();
        }
        if (this.throwable instanceof RuntimeException || this.throwable instanceof Error) {
            return;
        }
        if (!new InvocationInfo(invocation).isValidException(this.throwable)) {
            throw Reporter.checkedExceptionInvalid(this.throwable);
        }
    }
}

