/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.bytebuddy.InlineByteBuddyMockMaker;
import org.mockito.internal.creation.bytebuddy.InterceptedInvocation;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockMethodDispatcher;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.util.concurrent.WeakConcurrentMap;

public class MockMethodAdvice
extends MockMethodDispatcher {
    final WeakConcurrentMap<Object, MockMethodInterceptor> interceptors;
    private final String identifier;
    private final SelfCallInfo selfCallInfo = new SelfCallInfo();

    public MockMethodAdvice(WeakConcurrentMap<Object, MockMethodInterceptor> interceptors, String identifier) {
        this.interceptors = interceptors;
        this.identifier = identifier;
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enter(@Identifier String identifier, @Advice.This Object mock, @Advice.Origin Method origin, @Advice.AllArguments Object[] arguments) throws Throwable {
        MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)mock);
        if (dispatcher == null || !dispatcher.isMocked(mock) || !dispatcher.isOverridden(mock, origin)) {
            return null;
        }
        return dispatcher.handle(mock, origin, arguments);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }

    public Callable<?> handle(Object instance, Method origin, Object[] arguments) throws Throwable {
        MockMethodInterceptor interceptor = this.interceptors.get(instance);
        if (interceptor == null) {
            return null;
        }
        InterceptedInvocation.SuperMethod superMethod = instance instanceof Serializable ? new SerializableSuperMethodCall(this.identifier, origin, instance, arguments) : new SuperMethodCall(this.selfCallInfo, origin, instance, arguments);
        return new ReturnValueWrapper(interceptor.doIntercept(instance, origin, arguments, superMethod));
    }

    public boolean isMock(Object instance) {
        return this.interceptors.containsKey(instance);
    }

    public boolean isMocked(Object instance) {
        return this.selfCallInfo.checkSuperCall(instance) && this.isMock(instance);
    }

    public boolean isOverridden(Object instance, Method origin) {
        Class<?> currentType = instance.getClass();
        while (true) {
            try {
                return origin.equals(currentType.getDeclaredMethod(origin.getName(), origin.getParameterTypes()));
            }
            catch (NoSuchMethodException ignored) {
                if ((currentType = currentType.getSuperclass()) != null) continue;
                return true;
            }
            break;
        }
    }

    private static Object tryInvoke(Method origin, Object instance, Object[] arguments) throws Throwable {
        try {
            return origin.invoke(instance, arguments);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            new ConditionalStackTraceFilter().filter(InlineByteBuddyMockMaker.hideRecursiveCall(cause, new Throwable().getStackTrace().length, origin.getDeclaringClass()));
            throw cause;
        }
    }

    public static class ForReadObject {
        public static void doReadObject(@Identifier String identifier, @This MockAccess thiz, @Argument(value=0) ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            MockMethodAdvice mockMethodAdvice = (MockMethodAdvice)MockMethodDispatcher.get((String)identifier, (Object)thiz);
            if (mockMethodAdvice != null) {
                mockMethodAdvice.interceptors.put(thiz, thiz.getMockitoInterceptor());
            }
        }
    }

    static class ForEquals {
        ForEquals() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String identifier, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Argument(value=0) Object other, @Advice.Return(readOnly=false) boolean equals, @Advice.Enter boolean skipped) {
            if (skipped) {
                equals = self == other;
            }
        }
    }

    static class ForHashCode {
        ForHashCode() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String id, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)id, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Return(readOnly=false) int hashCode, @Advice.Enter boolean skipped) {
            if (skipped) {
                hashCode = System.identityHashCode(self);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Identifier {
    }

    private static class SelfCallInfo
    extends ThreadLocal<Object> {
        private SelfCallInfo() {
        }

        boolean checkSuperCall(Object value) {
            Object current = this.get();
            if (current == value) {
                this.set(null);
                return false;
            }
            return true;
        }
    }

    private static class ReturnValueWrapper
    implements Callable<Object> {
        private final Object returned;

        private ReturnValueWrapper(Object returned) {
            this.returned = returned;
        }

        @Override
        public Object call() {
            return this.returned;
        }
    }

    private static class SerializableSuperMethodCall
    implements InterceptedInvocation.SuperMethod {
        private final String identifier;
        private final SerializableMethod origin;
        private final Object instance;
        private final Object[] arguments;

        private SerializableSuperMethodCall(String identifier, Method origin, Object instance, Object[] arguments) {
            this.origin = new SerializableMethod(origin);
            this.identifier = identifier;
            this.instance = instance;
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            MockMethodDispatcher mockMethodDispatcher;
            Method method = this.origin.getJavaMethod();
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers() & method.getModifiers())) {
                method.setAccessible(true);
            }
            if (!((mockMethodDispatcher = MockMethodDispatcher.get((String)this.identifier, (Object)this.instance)) instanceof MockMethodAdvice)) {
                throw new MockitoException("Unexpected dispatcher for advice-based super call");
            }
            ((MockMethodAdvice)mockMethodDispatcher).selfCallInfo.set(this.instance);
            return MockMethodAdvice.tryInvoke(method, this.instance, this.arguments);
        }
    }

    private static class SuperMethodCall
    implements InterceptedInvocation.SuperMethod {
        private final SelfCallInfo selfCallInfo;
        private final Method origin;
        private final Object instance;
        private final Object[] arguments;

        private SuperMethodCall(SelfCallInfo selfCallInfo, Method origin, Object instance, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.instance = instance;
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            if (!Modifier.isPublic(this.origin.getDeclaringClass().getModifiers() & this.origin.getModifiers())) {
                this.origin.setAccessible(true);
            }
            this.selfCallInfo.set(this.instance);
            return MockMethodAdvice.tryInvoke(this.origin, this.instance, this.arguments);
        }
    }
}

