package org.mockito.internal.stubbing;

import org.mockito.internal.invocation.InvocationComparator;
import org.mockito.stubbing.Stubbing;

import java.util.Comparator;

/**
 * Compares stubbings based on {@link InvocationComparator}
 */
public class StubbingComparator implements Comparator<Stubbing> {

    private final InvocationComparator invocationComparator = new InvocationComparator();

    public int compare(Stubbing o1, Stubbing o2) {
        return invocationComparator.compare(o1.getInvocation(), o2.getInvocation());
    }
}
