/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.command;

import java.util.Arrays;
import java.util.List;
import org.mockftpserver.core.CommandSyntaxException;
import org.mockftpserver.core.util.Assert;

public final class Command {
    private String name;
    private String[] parameters;

    public Command(String name, String[] parameters) {
        Assert.notNull(name, "name");
        Assert.notNull(parameters, "parameters");
        this.name = name;
        this.parameters = Command.copy(parameters);
    }

    public Command(String name, List parameters) {
        this(name, parameters.toArray(new String[parameters.size()]));
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return Command.copy(this.parameters);
    }

    public String getRequiredParameter(int index) {
        this.assertValidIndex(index);
        return this.parameters[index];
    }

    public String getParameter(int index) {
        return this.parameters.length > index ? this.parameters[index] : null;
    }

    public String getOptionalString(int index) {
        return this.getParameter(index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Command)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        String str = this.name + Arrays.asList(this.parameters);
        return str.hashCode();
    }

    public String toString() {
        return "Command[" + this.name + ":" + Arrays.asList(this.parameters) + "]";
    }

    public static String normalizeName(String name) {
        return name.toUpperCase();
    }

    private static String[] copy(String[] array) {
        String[] newArray = new String[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private void assertValidIndex(int index) {
        if (index < 0 || index >= this.parameters.length) {
            throw new CommandSyntaxException("The parameter index " + index + " is not valid for " + this);
        }
    }
}

