/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.filters.RequestResponseLogFilter;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.http.HttpProxyUnificationHandler;
import org.mockserver.stop.StopEventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxy
implements Proxy {
    private static final Logger logger = LoggerFactory.getLogger(HttpProxy.class);
    private static ProxySelector previousProxySelector;
    private final RequestLogFilter requestLogFilter = new RequestLogFilter();
    private final RequestResponseLogFilter requestResponseLogFilter = new RequestResponseLogFilter();
    private final SettableFuture<String> hasStarted;
    private final SettableFuture<String> stopping = SettableFuture.create();
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private StopEventQueue stopEventQueue = new StopEventQueue();
    private Channel channel;

    public HttpProxy(final Integer port) {
        if (port == null) {
            throw new IllegalArgumentException("You must specify a port");
        }
        this.hasStarted = SettableFuture.create();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpProxy.this.channel = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(HttpProxy.this.bossGroup, HttpProxy.this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new HttpProxyUnificationHandler()).childAttr(Proxy.HTTP_PROXY, (Object)HttpProxy.this).childAttr(Proxy.HTTP_CONNECT_SOCKET, (Object)new InetSocketAddress(port)).childAttr(Proxy.REQUEST_LOG_FILTER, (Object)HttpProxy.this.requestLogFilter).childAttr(Proxy.REQUEST_RESPONSE_LOG_FILTER, (Object)HttpProxy.this.requestResponseLogFilter).bind(port.intValue()).syncUninterruptibly().channel();
                    logger.info("MockServer proxy started on port: {}", (Object)((InetSocketAddress)HttpProxy.this.channel.localAddress()).getPort());
                    HttpProxy.this.proxyStarted(port);
                    HttpProxy.this.hasStarted.set((Object)"STARTED");
                    HttpProxy.this.channel.closeFuture().syncUninterruptibly();
                }
                finally {
                    HttpProxy.this.bossGroup.shutdownGracefully();
                    HttpProxy.this.workerGroup.shutdownGracefully();
                }
            }
        }, "MockServer HttpProxy Thread").start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            logger.warn("Exception while waiting for MockServer proxy to complete starting up", (Throwable)e);
        }
    }

    private static ProxySelector createProxySelector(final String host, final int port) {
        return new ProxySelector(){

            @Override
            public List<java.net.Proxy> select(URI uri) {
                return Collections.singletonList(new java.net.Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                logger.error("Connection could not be established to proxy at socket [" + sa + "]", (Throwable)ioe);
            }
        };
    }

    @Override
    public Future<?> stop() {
        this.proxyStopping();
        return this.stopEventQueue.stop(this, this.stopping, this.bossGroup, this.workerGroup);
    }

    public HttpProxy withStopEventQueue(StopEventQueue stopEventQueue) {
        this.stopEventQueue = stopEventQueue;
        this.stopEventQueue.register(this);
        return this;
    }

    @Override
    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown() || !this.stopping.isDone();
    }

    public Integer getPort() {
        return ((InetSocketAddress)this.channel.localAddress()).getPort();
    }

    protected void proxyStarted(Integer port) {
        ConfigurationProperties.proxyPort((Integer[])new Integer[]{port});
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", port.toString());
    }

    protected void proxyStopping() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
    }
}

