/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver.callback;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.mockserver.client.netty.websocket.WebSocketException;
import org.mockserver.client.serialization.WebSocketMessageSerializer;
import org.mockserver.client.serialization.model.WebSocketClientIdDTO;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.mockserver.callback.ExpectationCallbackResponse;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class WebSocketClientRegistry {
    private WebSocketMessageSerializer webSocketMessageSerializer = new WebSocketMessageSerializer();
    private CircularHashMap<String, ChannelHandlerContext> clientRegistry = new CircularHashMap(100);
    private CircularHashMap<String, ExpectationCallbackResponse> callbackResponseRegistry = new CircularHashMap(100);

    void receivedTextWebSocketFrame(ChannelHandlerContext ctx, TextWebSocketFrame textWebSocketFrame) {
        block4: {
            try {
                Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
                if (deserializedMessage instanceof HttpResponse) {
                    String key = (String)this.clientRegistry.findKey((Object)ctx);
                    if (key != null) {
                        ((ExpectationCallbackResponse)this.callbackResponseRegistry.get((Object)key)).handle((HttpResponse)deserializedMessage);
                    }
                    break block4;
                }
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
            catch (Exception e) {
                throw new WebSocketException("Exception while receiving web socket message" + textWebSocketFrame.text(), (Throwable)e);
            }
        }
    }

    void registerClient(String clientId, ChannelHandlerContext ctx) {
        try {
            ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize((Object)new WebSocketClientIdDTO().setClientId(clientId))));
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket registration client id message to client " + clientId, (Throwable)e);
        }
        this.clientRegistry.put((Object)clientId, (Object)ctx);
    }

    public void registerCallbackResponseHandler(String clientId, ExpectationCallbackResponse expectationCallbackResponse) {
        this.callbackResponseRegistry.put((Object)clientId, (Object)expectationCallbackResponse);
    }

    public void sendClientMessage(String clientId, HttpRequest httpRequest) {
        try {
            if (this.clientRegistry.containsKey((Object)clientId)) {
                ((ChannelHandlerContext)this.clientRegistry.get((Object)clientId)).channel().writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize((Object)httpRequest)));
            }
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket message " + httpRequest + " to client " + clientId, (Throwable)e);
        }
    }
}

