/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.base.Joiner;
import com.google.common.net.MediaType;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.BindException;
import java.util.List;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.callback.ExpectationCallbackResponse;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.model.Action;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.validator.ExpectationValidator;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private LogFormatter logFormatter = new LogFormatter(this.logger);
    private MockServer server;
    private RequestLogFilter requestLogFilter;
    private MockServerMatcher mockServerMatcher;
    private WebSocketClientRegistry webSocketClientRegistry;
    private ActionHandler actionHandler;
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();
    private ExpectationValidator expectationValidator = new ExpectationValidator();

    public MockServerHandler(MockServer server, MockServerMatcher mockServerMatcher, WebSocketClientRegistry webSocketClientRegistry, RequestLogFilter requestLogFilter) {
        this.server = server;
        this.requestLogFilter = requestLogFilter;
        this.mockServerMatcher = mockServerMatcher;
        this.webSocketClientRegistry = webSocketClientRegistry;
        this.actionHandler = new ActionHandler(requestLogFilter);
    }

    protected void channelRead0(final ChannelHandlerContext ctx, final HttpRequest request) {
        block42: {
            try {
                if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && request.getMethod().getValue().equals("OPTIONS") && !request.getFirstHeader("Origin").isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                    break block42;
                }
                if (request.matches("PUT", "/status")) {
                    List<Integer> actualPortBindings = this.server.getPorts();
                    this.writeResponse(ctx, request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                    break block42;
                }
                if (request.matches("PUT", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindToPorts(requestedPortBindings.getPorts());
                        this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block42;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block42;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/expectation")) {
                    for (Expectation expectation : this.expectationSerializer.deserializeArray(request.getBodyAsString())) {
                        List validationErrors = this.expectationValidator.isValid(expectation);
                        if (validationErrors.isEmpty()) {
                            KeyAndCertificateFactory.addSubjectAlternativeName((String)expectation.getHttpRequest().getFirstHeader(HttpHeaderNames.HOST.toString()));
                            this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes(), expectation.getTimeToLive()).thenRespond(expectation.getHttpResponse()).thenForward(expectation.getHttpForward()).thenError(expectation.getHttpError()).thenCallback(expectation.getHttpClassCallback()).thenCallback(expectation.getHttpObjectCallback());
                            this.logFormatter.infoLog("creating expectation:{}", new Object[]{expectation});
                            this.writeResponse(ctx, request, HttpResponseStatus.CREATED);
                            continue;
                        }
                        String errorMessage = validationErrors.size() + " errors:\n - " + Joiner.on((String)"\n - ").join((Iterable)validationErrors) + "\n";
                        this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, errorMessage, MediaType.create((String)"text", (String)"plain").toString());
                    }
                } else if (request.matches("PUT", "/clear")) {
                    HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                    if (request.hasQueryStringParameter("type", "expectation")) {
                        this.logFormatter.infoLog("clearing expectations that match:{}", new Object[]{httpRequest});
                        this.mockServerMatcher.clear(httpRequest);
                    } else if (request.hasQueryStringParameter("type", "log")) {
                        this.logFormatter.infoLog("clearing request logs that match:{}", new Object[]{httpRequest});
                        this.requestLogFilter.clear(httpRequest);
                    } else {
                        this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                        this.requestLogFilter.clear(httpRequest);
                        this.mockServerMatcher.clear(httpRequest);
                    }
                    this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else if (request.matches("PUT", "/reset")) {
                    this.requestLogFilter.reset();
                    this.mockServerMatcher.reset();
                    this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else if (request.matches("PUT", "/dumpToLog")) {
                    this.mockServerMatcher.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                    this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                } else if (request.matches("PUT", "/retrieve")) {
                    HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                    if (request.hasQueryStringParameter("type", "expectation")) {
                        Expectation[] expectations = this.mockServerMatcher.retrieveExpectations(httpRequest);
                        this.logFormatter.infoLog("retrieving expectations that match:{}", new Object[]{httpRequest});
                        this.writeResponse(ctx, request, HttpResponseStatus.OK, this.expectationSerializer.serialize(expectations), "application/json");
                    } else {
                        HttpRequest[] requests = this.requestLogFilter.retrieve(httpRequest);
                        this.logFormatter.infoLog("retrieving requests that match:{}", new Object[]{httpRequest});
                        this.writeResponse(ctx, request, HttpResponseStatus.OK, this.httpRequestSerializer.serialize(requests), "application/json");
                    }
                } else if (request.matches("PUT", "/verify")) {
                    Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                    String result = this.requestLogFilter.verify(verification);
                    this.logFormatter.infoLog("verifying requests that match:{}", new Object[]{verification});
                    if (result.isEmpty()) {
                        this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                    } else {
                        this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                    }
                } else if (request.matches("PUT", "/verifySequence")) {
                    VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                    String result = this.requestLogFilter.verify(verificationSequence);
                    this.logFormatter.infoLog("verifying sequence that match:{}", new Object[]{verificationSequence});
                    if (result.isEmpty()) {
                        this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
                    } else {
                        this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
                    }
                } else if (request.matches("PUT", "/stop")) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.ACCEPTED.code())));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MockServerHandler.this.server.stop();
                        }
                    }).start();
                } else {
                    Action handle = this.mockServerMatcher.retrieveAction(request);
                    if (handle instanceof HttpError) {
                        ChannelHandlerContext httpCodecContext;
                        HttpError httpError = ((HttpError)handle).applyDelay();
                        if (httpError.getResponseBytes() != null && (httpCodecContext = ctx.pipeline().context(HttpServerCodec.class)) != null) {
                            httpCodecContext.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])httpError.getResponseBytes())).awaitUninterruptibly();
                        }
                        if (httpError.getDropConnection().booleanValue()) {
                            ctx.close();
                        }
                    } else if (handle instanceof HttpObjectCallback) {
                        String clientId = ((HttpObjectCallback)handle).getClientId();
                        this.webSocketClientRegistry.registerCallbackResponseHandler(clientId, new ExpectationCallbackResponse(){

                            @Override
                            public void handle(HttpResponse response) {
                                MockServerHandler.this.logFormatter.infoLog("returning response:{}" + System.getProperty("line.separator") + " for request:{}", new Object[]{response, request});
                                MockServerHandler.this.writeResponse(ctx, request, response.withConnectionOptions(ConnectionOptions.connectionOptions().withCloseSocket(Boolean.valueOf(true))));
                            }
                        });
                        this.webSocketClientRegistry.sendClientMessage(clientId, request);
                    } else {
                        HttpResponse response = this.actionHandler.processAction(handle, request);
                        this.logFormatter.infoLog("returning response:{}" + System.getProperty("line.separator") + " for request:{}", new Object[]{response, request});
                        this.writeResponse(ctx, request, response);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Exception processing " + request, (Throwable)e);
                this.writeResponse(ctx, request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(e.getMessage()));
            }
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        if (ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders(response);
        }
        this.writeResponse(ctx, request, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders(response);
        }
        this.addConnectionHeader(request, response);
        this.writeAndCloseSocket(ctx, request, response);
    }

    private void addCORSHeaders(HttpResponse response) {
        String methods = "CONNECT, DELETE, GET, HEAD, OPTIONS, POST, PUT, TRACE";
        String headers = "Allow, Content-Encoding, Content-Length, Content-Type, ETag, Expires, Last-Modified, Location, Server, Vary";
        if (response.getFirstHeader("Access-Control-Allow-Origin").isEmpty()) {
            response.withHeader("Access-Control-Allow-Origin", new String[]{"*"});
        }
        if (response.getFirstHeader("Access-Control-Allow-Methods").isEmpty()) {
            response.withHeader("Access-Control-Allow-Methods", new String[]{methods});
        }
        if (response.getFirstHeader("Access-Control-Allow-Headers").isEmpty()) {
            response.withHeader("Access-Control-Allow-Headers", new String[]{headers});
        }
        if (response.getFirstHeader("Access-Control-Expose-Headers").isEmpty()) {
            response.withHeader("Access-Control-Expose-Headers", new String[]{headers});
        }
        if (response.getFirstHeader("Access-Control-Max-Age").isEmpty()) {
            response.withHeader("Access-Control-Max-Age", new String[]{"1"});
        }
        if (response.getFirstHeader("X-CORS").isEmpty()) {
            response.withHeader("X-CORS", new String[]{"MockServer CORS support enabled by default, to disable ConfigurationProperties.enableCORSForAPI(false) or -Dmockserver.disableCORS=false"});
        }
    }

    private void addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getKeepAliveOverride() != null) {
            if (connectionOptions.getKeepAliveOverride().booleanValue()) {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            } else {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            }
        } else if (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getSuppressConnectionHeader())) {
            if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue() && (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getCloseSocket()))) {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            } else {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            }
        }
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean closeChannel;
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getCloseSocket() != null) {
            closeChannel = connectionOptions.getCloseSocket();
        } else {
            boolean bl = closeChannel = request.isKeepAlive() == null || request.isKeepAlive() == false;
        }
        if (closeChannel) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.write((Object)response);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("Connection reset by peer")) {
            this.logger.warn("Exception caught by MockServer handler -> closing pipeline", cause);
        }
        ctx.close();
    }
}

