/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.velocity;

import java.io.StringWriter;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.velocity.script.VelocityScriptEngineFactory;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.model.DTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;
import org.slf4j.event.Level;

public class VelocityTemplateEngine
implements TemplateEngine {
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final ScriptEngine engine;
    private final MockServerLogger logFormatter;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;

    public VelocityTemplateEngine(MockServerLogger logFormatter) {
        this.logFormatter = logFormatter;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(logFormatter);
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        Object result;
        try {
            StringWriter writer = new StringWriter();
            ScriptContext context = engine.getContext();
            context.setWriter(writer);
            context.setAttribute("request", new HttpRequestTemplateObject(request), 100);
            engine.eval(template);
            this.logFormatter.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TEMPLATE_GENERATED).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("generated output:{}from template:{}for request:{}").setArguments(((Object)writer).toString(), template, request));
            result = this.httpTemplateOutputDeserializer.deserializer(request, ((Object)writer).toString(), dtoClass);
        }
        catch (Exception e) {
            throw new RuntimeException(StringFormatter.formatLogMessage("Exception transforming template:{}for request:{}", template, request), e);
        }
        return result;
    }

    static {
        manager.registerEngineName("velocity", (ScriptEngineFactory)new VelocityScriptEngineFactory());
        engine = manager.getEngineByName("velocity");
    }
}

