/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.util.UUID;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;
import org.slf4j.event.Level;

public class HttpResponseObjectCallbackActionHandler {
    private WebSocketClientRegistry webSocketClientRegistry;
    private final MockServerLogger mockServerLogger;

    public HttpResponseObjectCallbackActionHandler(HttpStateHandler httpStateHandler) {
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    public void handle(ActionHandler actionHandler, HttpObjectCallback httpObjectCallback, HttpRequest request, ResponseWriter responseWriter, boolean synchronous, Runnable expectationPostProcessor) {
        String clientId = httpObjectCallback.getClientId();
        String webSocketCorrelationId = UUID.randomUUID().toString();
        this.webSocketClientRegistry.registerResponseCallbackHandler(webSocketCorrelationId, response -> {
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("received response over websocket{}for request{}from client " + clientId + " for correlationId " + webSocketCorrelationId).setArguments(response, request));
            }
            this.webSocketClientRegistry.unregisterResponseCallbackHandler(webSocketCorrelationId);
            if (expectationPostProcessor != null) {
                expectationPostProcessor.run();
            }
            actionHandler.writeResponseActionResponse(response.removeHeader("WebSocketCorrelationId"), responseWriter, request, httpObjectCallback, synchronous);
        });
        if (!this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId), null)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setHttpRequest(request).setMessageFormat("returning{}because client " + clientId + " has closed web socket connection").setArguments(HttpResponse.notFoundResponse()));
            actionHandler.writeResponseActionResponse(HttpResponse.notFoundResponse(), responseWriter, request, httpObjectCallback, synchronous);
        } else if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("sending request over websocket{}to client " + clientId + " for correlationId " + webSocketCorrelationId).setArguments(request));
        }
    }
}

