/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class SubStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] excludedFields = new String[]{"mockserverLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;

    SubStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        if (StringUtils.isEmpty((CharSequence)matcher)) {
            return true;
        }
        if (matched != null) {
            if (StringUtils.contains((CharSequence)matched, (CharSequence)matcher)) {
                return true;
            }
            if (ignoreCase) {
                return StringUtils.containsIgnoreCase((CharSequence)matched, (CharSequence)matcher);
            }
        }
        return false;
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        return this.matches(context, NottableString.string(matched));
    }

    @Override
    public boolean matches(HttpRequest context, NottableString matched) {
        boolean result = false;
        if (SubStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("failed to perform substring match{}with{}").setArguments(matched, this.matcher));
        }
        return matched.isNot() == (this.matcher.isNot() == (this.not != result));
    }

    @Override
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

