/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class ExactStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;

    ExactStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        if (StringUtils.isBlank((CharSequence)matcher)) {
            return true;
        }
        if (matched != null) {
            if (matched.equals(matcher)) {
                return true;
            }
            if (ignoreCase) {
                return matched.equalsIgnoreCase(matcher);
            }
        }
        return false;
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        return this.matches(context, NottableString.string(matched));
    }

    @Override
    public boolean matches(HttpRequest context, NottableString matched) {
        boolean result = false;
        if (ExactStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("failed to perform exact string match of{}with{}").setArguments(matched, this.matcher));
        }
        return matched.isNot() == (this.matcher.isNot() == (this.not != result));
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

