package org.mockserver.serialization.model;

import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;

import java.util.Objects;

/**
 * @author jamesdbloom
 */
public class ParameterBodyDTO extends BodyDTO {

    private final Parameters parameters;

    public ParameterBodyDTO(ParameterBody parameterBody) {
        this(parameterBody, false);
    }

    public ParameterBodyDTO(ParameterBody parameterBody, Boolean not) {
        super(parameterBody.getType(), not);
        parameters = parameterBody.getValue();
    }

    public Parameters getParameters() {
        return parameters;
    }

    public ParameterBody buildObject() {
        return new ParameterBody(parameters);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterBodyDTO)) {
            return false;
        }
        ParameterBodyDTO that = (ParameterBodyDTO) o;
        return Objects.equals(parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(parameters);
    }
}
