package org.mockserver;

public final class Version {

    private static final String VERSION = "5.9.0";
    private static final String GROUPID = "org.mock-server";
    private static final String ARTIFACTID = "mockserver-core";

    private static String getValue(String value, String defaultValue) {
        if (!value.startsWith("$")) {
            return value;
        } else {
            return defaultValue;
        }
    }

    public static String getVersion() {
        return getValue(VERSION, System.getProperty("MOCKSERVER_VERSION", ""));
    }

    public static String getGroupId() {
        return getValue(GROUPID, "");
    }

    public static String getArtifactId() {
        return getValue(ARTIFACTID, "");
    }

}