/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.velocity;

import java.io.StringWriter;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.velocity.script.VelocityScriptEngineFactory;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.model.DTO;
import org.mockserver.logging.LogFormatter;
import org.mockserver.model.HttpRequest;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityTemplateEngine
implements TemplateEngine {
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final ScriptEngine engine;
    private static Logger logger;
    private static LogFormatter logFormatter;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer();

    @Override
    public <T> T executeTemplate(String template, HttpRequest httpRequest, Class<? extends DTO<T>> dtoClass) {
        try {
            StringWriter writer = new StringWriter();
            ScriptContext context = engine.getContext();
            context.setWriter(writer);
            context.setAttribute("request", new HttpRequestTemplateObject(httpRequest), 100);
            engine.eval(template);
            logFormatter.infoLog("Generated output:{}" + Character.NEW_LINE + " from template:{}" + Character.NEW_LINE + " for request:{}", ((Object)writer).toString(), template, httpRequest);
            return this.httpTemplateOutputDeserializer.deserializer(((Object)writer).toString(), dtoClass);
        }
        catch (Exception e) {
            throw new RuntimeException(logFormatter.formatLogMessage("Exception transforming template:{}" + Character.NEW_LINE + " for request:{}", template, httpRequest).toString(), e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(VelocityTemplateEngine.class);
        logFormatter = new LogFormatter(logger);
        manager.registerEngineName("velocity", (ScriptEngineFactory)new VelocityScriptEngineFactory());
        engine = manager.getEngineByName("velocity");
    }
}

