/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Strings;
import java.io.IOException;
import org.mockserver.client.serialization.model.HttpRequestDTO;

public class HttpRequestDTOSerializer
extends StdSerializer<HttpRequestDTO> {
    public HttpRequestDTOSerializer() {
        super(HttpRequestDTO.class);
    }

    public void serialize(HttpRequestDTO httpRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (httpRequest.getNot() != null && httpRequest.getNot().booleanValue()) {
            jgen.writeBooleanField("not", httpRequest.getNot().booleanValue());
        }
        if (httpRequest.getMethod() != null && !Strings.isNullOrEmpty((String)httpRequest.getMethod().getValue())) {
            jgen.writeObjectField("method", (Object)httpRequest.getMethod());
        }
        if (httpRequest.getPath() != null && !Strings.isNullOrEmpty((String)httpRequest.getPath().getValue())) {
            jgen.writeObjectField("path", (Object)httpRequest.getPath());
        }
        if (httpRequest.getQueryStringParameters() != null && !httpRequest.getQueryStringParameters().isEmpty()) {
            jgen.writeObjectField("queryStringParameters", httpRequest.getQueryStringParameters());
        }
        if (httpRequest.getHeaders() != null && !httpRequest.getHeaders().isEmpty()) {
            jgen.writeObjectField("headers", httpRequest.getHeaders());
        }
        if (httpRequest.getCookies() != null && !httpRequest.getCookies().isEmpty()) {
            jgen.writeObjectField("cookies", httpRequest.getCookies());
        }
        if (httpRequest.getKeepAlive() != null) {
            jgen.writeBooleanField("keepAlive", httpRequest.getKeepAlive().booleanValue());
        }
        if (httpRequest.getSecure() != null) {
            jgen.writeBooleanField("secure", httpRequest.getSecure().booleanValue());
        }
        if (httpRequest.getBody() != null) {
            jgen.writeObjectField("body", (Object)httpRequest.getBody());
        }
        jgen.writeEndObject();
    }
}

