/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.model.BinaryBodyDTO;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.JsonBodyDTO;
import org.mockserver.client.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.client.serialization.model.ParameterBodyDTO;
import org.mockserver.client.serialization.model.RegexBodyDTO;
import org.mockserver.client.serialization.model.StringBodyDTO;
import org.mockserver.client.serialization.model.XPathBodyDTO;
import org.mockserver.client.serialization.model.XmlBodyDTO;
import org.mockserver.client.serialization.model.XmlSchemaBodyDTO;
import org.mockserver.logging.LogFormatter;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.BooleanMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.HashMapMatcher;
import org.mockserver.matchers.JsonSchemaMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.matchers.ParameterStringMatcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.XPathStringMatcher;
import org.mockserver.matchers.XmlSchemaMatcher;
import org.mockserver.matchers.XmlStringMatcher;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;

public class HttpRequestMatcher
extends NotMatcher<HttpRequest> {
    private LogFormatter logFormatter;
    private HttpRequest httpRequest;
    private RegexStringMatcher methodMatcher;
    private RegexStringMatcher pathMatcher;
    private MultiValueMapMatcher queryStringParameterMatcher;
    private BodyMatcher bodyMatcher;
    private MultiValueMapMatcher headerMatcher;
    private HashMapMatcher cookieMatcher;
    private BooleanMatcher keepAliveMatcher;
    private BodyDTO bodyDTOMatcher;
    private BooleanMatcher sslMatcher;
    private ObjectMapper objectMapper;

    public HttpRequestMatcher(HttpRequest httpRequest) {
        this.logFormatter = new LogFormatter(this.logger);
        this.methodMatcher = null;
        this.pathMatcher = null;
        this.queryStringParameterMatcher = null;
        this.bodyMatcher = null;
        this.headerMatcher = null;
        this.cookieMatcher = null;
        this.keepAliveMatcher = null;
        this.bodyDTOMatcher = null;
        this.sslMatcher = null;
        this.objectMapper = ObjectMapperFactory.createObjectMapper();
        this.httpRequest = httpRequest;
        if (httpRequest != null) {
            this.withMethod(httpRequest.getMethod());
            this.withPath(httpRequest.getPath());
            this.withQueryStringParameters(httpRequest.getQueryStringParameters());
            this.withBody(httpRequest.getBody());
            this.withHeaders(httpRequest.getHeaders());
            this.withCookies(httpRequest.getCookies());
            this.withKeepAlive(httpRequest.isKeepAlive());
            this.withSsl(httpRequest.isSecure());
        }
        this.addFieldsExcludedFromEqualsAndHashCode("logFormatter", "objectMapper");
    }

    private HttpRequestMatcher withMethod(NottableString method) {
        this.methodMatcher = new RegexStringMatcher(method);
        return this;
    }

    private HttpRequestMatcher withPath(NottableString path) {
        this.pathMatcher = new RegexStringMatcher(path);
        return this;
    }

    private HttpRequestMatcher withQueryStringParameters(List<Parameter> parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(parameters));
        return this;
    }

    private HttpRequestMatcher withBody(Body body) {
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    StringBody stringBody = (StringBody)body;
                    this.bodyDTOMatcher = new StringBodyDTO(stringBody);
                    this.bodyMatcher = new ExactStringMatcher(NottableString.string(stringBody.getValue(), stringBody.getNot()));
                    break;
                }
                case REGEX: {
                    RegexBody regexBody = (RegexBody)body;
                    this.bodyDTOMatcher = new RegexBodyDTO(regexBody);
                    this.bodyMatcher = new RegexStringMatcher(NottableString.string(regexBody.getValue(), regexBody.getNot()));
                    break;
                }
                case PARAMETERS: {
                    ParameterBody parameterBody = (ParameterBody)body;
                    this.bodyDTOMatcher = new ParameterBodyDTO(parameterBody);
                    this.bodyMatcher = new ParameterStringMatcher((List<Parameter>)parameterBody.getValue());
                    break;
                }
                case XPATH: {
                    XPathBody xPathBody = (XPathBody)body;
                    this.bodyDTOMatcher = new XPathBodyDTO(xPathBody);
                    this.bodyMatcher = new XPathStringMatcher(xPathBody.getValue());
                    break;
                }
                case XML: {
                    XmlBody xmlBody = (XmlBody)body;
                    this.bodyDTOMatcher = new XmlBodyDTO(xmlBody);
                    this.bodyMatcher = new XmlStringMatcher(xmlBody.getValue());
                    break;
                }
                case JSON: {
                    JsonBody jsonBody = (JsonBody)body;
                    this.bodyDTOMatcher = new JsonBodyDTO(jsonBody);
                    this.bodyMatcher = new JsonStringMatcher(jsonBody.getValue(), jsonBody.getMatchType());
                    break;
                }
                case JSON_SCHEMA: {
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)body;
                    this.bodyDTOMatcher = new JsonSchemaBodyDTO(jsonSchemaBody);
                    this.bodyMatcher = new JsonSchemaMatcher(jsonSchemaBody.getValue());
                    break;
                }
                case XML_SCHEMA: {
                    XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)body;
                    this.bodyDTOMatcher = new XmlSchemaBodyDTO(xmlSchemaBody);
                    this.bodyMatcher = new XmlSchemaMatcher(xmlSchemaBody.getValue());
                    break;
                }
                case BINARY: {
                    BinaryBody binaryBody = (BinaryBody)body;
                    this.bodyDTOMatcher = new BinaryBodyDTO(binaryBody);
                    this.bodyMatcher = new BinaryMatcher(binaryBody.getValue());
                }
            }
            if (body.isNot()) {
                this.bodyMatcher = HttpRequestMatcher.not(this.bodyMatcher);
            }
        }
        return this;
    }

    private HttpRequestMatcher withHeaders(Header ... headers) {
        this.headerMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpRequestMatcher withHeaders(List<Header> headers) {
        this.headerMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpRequestMatcher withCookies(Cookie ... cookies) {
        this.cookieMatcher = new HashMapMatcher(KeyAndValue.toHashMap(cookies));
        return this;
    }

    private HttpRequestMatcher withCookies(List<Cookie> cookies) {
        this.cookieMatcher = new HashMapMatcher(KeyAndValue.toHashMap(cookies));
        return this;
    }

    private HttpRequestMatcher withKeepAlive(Boolean keepAlive) {
        this.keepAliveMatcher = new BooleanMatcher(keepAlive);
        return this;
    }

    private HttpRequestMatcher withSsl(Boolean isSsl) {
        this.sslMatcher = new BooleanMatcher(isSsl);
        return this;
    }

    @Override
    public boolean matches(HttpRequest httpRequest) {
        return this.matches(httpRequest, false);
    }

    public boolean matches(HttpRequest httpRequest, boolean logMatchResults) {
        if (httpRequest == this.httpRequest) {
            return true;
        }
        if (this.httpRequest == null) {
            return true;
        }
        if (httpRequest != null) {
            boolean totalResultAfterNotOperatorApplied;
            boolean methodMatches = Strings.isNullOrEmpty((String)httpRequest.getMethod().getValue()) || this.matches(this.methodMatcher, httpRequest.getMethod());
            boolean pathMatches = Strings.isNullOrEmpty((String)httpRequest.getPath().getValue()) || this.matches(this.pathMatcher, httpRequest.getPath());
            boolean queryStringParametersMatches = this.matches(this.queryStringParameterMatcher, httpRequest.getQueryStringParameters() != null ? new ArrayList<Parameter>(httpRequest.getQueryStringParameters()) : null);
            String bodyAsString = httpRequest.getBody() != null ? new String(httpRequest.getBody().getRawBytes(), httpRequest.getBody().getCharset(Charsets.UTF_8)) : "";
            BodyDTO bodyDTO = null;
            try {
                bodyDTO = (BodyDTO)this.objectMapper.readValue(bodyAsString, BodyDTO.class);
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean bodyMatches = bodyDTO == null || this.bodyDTOMatcher == null || bodyDTO.getType() == Body.Type.STRING ? (this.bodyMatcher instanceof BinaryMatcher ? this.matches(this.bodyMatcher, httpRequest.getBodyAsRawBytes()) : (this.bodyMatcher instanceof ExactStringMatcher || this.bodyMatcher instanceof RegexStringMatcher || this.bodyMatcher instanceof XmlStringMatcher ? this.matches(this.bodyMatcher, NottableString.string(bodyAsString)) : this.matches(this.bodyMatcher, bodyAsString))) : this.bodyDTOMatcher.equals(bodyDTO);
            boolean headersMatch = this.matches(this.headerMatcher, httpRequest.getHeaders() != null ? new ArrayList<Header>(httpRequest.getHeaders()) : null);
            boolean cookiesMatch = this.matches(this.cookieMatcher, httpRequest.getCookies() != null ? new ArrayList<Cookie>(httpRequest.getCookies()) : null);
            boolean keepAliveMatches = this.matches(this.keepAliveMatcher, httpRequest.isKeepAlive());
            boolean sslMatches = this.matches(this.sslMatcher, httpRequest.isSecure());
            boolean totalResult = methodMatches && pathMatches && queryStringParametersMatches && bodyMatches && headersMatch && cookiesMatch && keepAliveMatches && sslMatches;
            boolean bl = totalResultAfterNotOperatorApplied = httpRequest.isNot() == (this.httpRequest.isNot() == (this.not != totalResult));
            if (logMatchResults && this.logger.isInfoEnabled()) {
                if (!totalResultAfterNotOperatorApplied) {
                    StringBuilder becauseBuilder = new StringBuilder();
                    becauseBuilder.append("method matches = ").append(methodMatches).append(Character.NEW_LINE);
                    becauseBuilder.append("path matches = ").append(pathMatches).append(Character.NEW_LINE);
                    becauseBuilder.append("query string parameters match = ").append(queryStringParametersMatches).append(Character.NEW_LINE);
                    becauseBuilder.append("body matches = ").append(bodyMatches).append(Character.NEW_LINE);
                    becauseBuilder.append("headers match = ").append(headersMatch).append(Character.NEW_LINE);
                    becauseBuilder.append("cookies match = ").append(cookiesMatch).append(Character.NEW_LINE);
                    becauseBuilder.append("keep-alive matches = ").append(keepAliveMatches).append(Character.NEW_LINE);
                    becauseBuilder.append("ssl matches = ").append(sslMatches).append(Character.NEW_LINE);
                    if (httpRequest.isNot()) {
                        becauseBuilder.append("request 'not' operator is enabled").append(Character.NEW_LINE);
                    }
                    if (this.httpRequest.isNot()) {
                        becauseBuilder.append("expectation's request 'not' operator is enabled").append(Character.NEW_LINE);
                    }
                    if (this.not) {
                        becauseBuilder.append("expectation's request matcher 'not' operator is enabled").append(Character.NEW_LINE);
                    }
                    this.logFormatter.infoLog("request:{}" + Character.NEW_LINE + " did" + (totalResult ? "" : " not") + " match expectation:{}" + Character.NEW_LINE + " because:{}", httpRequest, this, becauseBuilder.toString());
                } else {
                    this.logFormatter.infoLog("request:{}" + Character.NEW_LINE + " matched expectation:{}", httpRequest, this);
                }
            }
            return totalResultAfterNotOperatorApplied;
        }
        return false;
    }

    private <T> boolean matches(Matcher<T> matcher, T t) {
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(t)) {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

