/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.filters.RequestFilter;
import org.mockserver.filters.ResponseFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogFilter
implements ResponseFilter,
RequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestLogFilter.class);
    private final EvictingQueue<HttpRequest> evictingQueue = EvictingQueue.create((int)100);
    private final Queue<HttpRequest> requestLog = Queues.synchronizedQueue(this.evictingQueue);
    private final MatcherBuilder matcherBuilder = new MatcherBuilder();
    private LogFormatter logFormatter = new LogFormatter(logger);
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();

    @Override
    public HttpResponse onResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
        return httpResponse;
    }

    public HttpRequest onRequest(HttpRequest httpRequest) {
        this.requestLog.add(httpRequest);
        return httpRequest;
    }

    public List<HttpRequest> httpRequests(HttpRequest httpRequest) {
        LinkedList<HttpRequest> requestLog = new LinkedList<HttpRequest>(this.requestLog);
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : requestLog) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpRequests.add(loggedHttpRequest);
        }
        return httpRequests;
    }

    public void reset() {
        this.requestLog.clear();
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequest value : new LinkedList<HttpRequest>(this.requestLog)) {
                if (!httpRequestMatcher.matches(value, true)) continue;
                this.requestLog.remove(value);
            }
        } else {
            this.reset();
        }
    }

    public HttpRequest[] retrieve(HttpRequest httpRequestToMatch) {
        LinkedList<HttpRequest> requestLog = new LinkedList<HttpRequest>(this.requestLog);
        ArrayList<HttpRequest> matchingRequests = new ArrayList<HttpRequest>();
        if (httpRequestToMatch != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequestToMatch);
            for (HttpRequest httpRequest : requestLog) {
                if (!httpRequestMatcher.matches(httpRequest, true)) continue;
                matchingRequests.add(httpRequest);
            }
        } else {
            matchingRequests.addAll(requestLog);
        }
        return matchingRequests.toArray(new HttpRequest[matchingRequests.size()]);
    }

    public String verify(Verification verification) {
        LinkedList<HttpRequest> requestLog = new LinkedList<HttpRequest>(this.requestLog);
        String failureMessage = "";
        if (verification != null) {
            ArrayList<HttpRequest> matchingRequests = new ArrayList<HttpRequest>();
            if (verification.getHttpRequest() != null) {
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verification.getHttpRequest());
                for (HttpRequest httpRequest : requestLog) {
                    if (!httpRequestMatcher.matches(httpRequest, true)) continue;
                    matchingRequests.add(httpRequest);
                }
            }
            boolean verified = true;
            if (verification.getTimes().getCount() != 0 && matchingRequests.isEmpty()) {
                verified = false;
            } else if (verification.getTimes().isExact() && matchingRequests.size() != verification.getTimes().getCount()) {
                verified = false;
            } else if (matchingRequests.size() < verification.getTimes().getCount()) {
                verified = false;
            }
            if (!verified) {
                HttpRequest[] allRequestsArray = requestLog.toArray(new HttpRequest[requestLog.size()]);
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(verification.getHttpRequest());
                String serializedAllRequestInLog = allRequestsArray.length == 1 ? this.httpRequestSerializer.serialize(allRequestsArray[0]) : this.httpRequestSerializer.serialize(allRequestsArray);
                this.logFormatter.infoLog("request not found " + verification.getTimes() + ", expected:{}" + Character.NEW_LINE + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                failureMessage = "Request not found " + verification.getTimes() + ", expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
            }
        }
        return failureMessage;
    }

    public String verify(VerificationSequence verificationSequence) {
        LinkedList<HttpRequest> requestLog = new LinkedList<HttpRequest>(this.requestLog);
        String failureMessage = "";
        if (verificationSequence != null) {
            int requestLogCounter = 0;
            for (HttpRequest verificationHttpRequest : verificationSequence.getHttpRequests()) {
                if (verificationHttpRequest == null) continue;
                HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(verificationHttpRequest);
                boolean foundRequest = false;
                while (!foundRequest && requestLogCounter < requestLog.size()) {
                    if (httpRequestMatcher.matches(requestLog.get(requestLogCounter), true)) {
                        foundRequest = true;
                    }
                    ++requestLogCounter;
                }
                if (foundRequest) continue;
                String serializedRequestToBeVerified = this.httpRequestSerializer.serialize(verificationSequence.getHttpRequests());
                String serializedAllRequestInLog = this.httpRequestSerializer.serialize((List<HttpRequest>)requestLog);
                failureMessage = "Request sequence not found, expected:<" + serializedRequestToBeVerified + "> but was:<" + serializedAllRequestInLog + ">";
                this.logFormatter.infoLog("request sequence not found, expected:{}" + Character.NEW_LINE + " but was:{}", serializedRequestToBeVerified, serializedAllRequestInLog);
                break;
            }
        }
        return failureMessage;
    }
}

