/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.response;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.StringBody;

public class HttpResponseSerializer
extends StdSerializer<HttpResponse> {
    public HttpResponseSerializer() {
        super(HttpResponse.class);
    }

    public void serialize(HttpResponse httpResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        BodyWithContentType body;
        jgen.writeStartObject();
        if (httpResponse.getStatusCode() != null) {
            jgen.writeObjectField("statusCode", (Object)httpResponse.getStatusCode());
        }
        if (httpResponse.getHeaders() != null && !httpResponse.getHeaders().isEmpty()) {
            jgen.writeObjectField("headers", httpResponse.getHeaders());
        }
        if (httpResponse.getCookies() != null && !httpResponse.getCookies().isEmpty()) {
            jgen.writeObjectField("cookies", httpResponse.getCookies());
        }
        if ((body = httpResponse.getBody()) != null) {
            if (body instanceof StringBody && !((StringBody)body).getValue().isEmpty()) {
                jgen.writeObjectField("body", (Object)body);
            } else if (body instanceof JsonBody && !((JsonBody)body).getValue().isEmpty()) {
                jgen.writeObjectField("body", (Object)((JsonBody)body).getValue());
            } else if (body instanceof BinaryBody) {
                jgen.writeObjectField("body", (Object)body);
            }
        }
        if (httpResponse.getDelay() != null) {
            jgen.writeObjectField("delay", (Object)httpResponse.getDelay());
        }
        if (httpResponse.getConnectionOptions() != null) {
            jgen.writeObjectField("connectionOptions", (Object)httpResponse.getConnectionOptions());
        }
        jgen.writeEndObject();
    }
}

