/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.client.serialization.java.ConnectionOptionsToJavaSerializer;
import org.mockserver.client.serialization.java.CookieToJavaSerializer;
import org.mockserver.client.serialization.java.DelayToJavaSerializer;
import org.mockserver.client.serialization.java.HeaderToJavaSerializer;
import org.mockserver.client.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class HttpResponseToJavaSerializer
implements ToJavaSerializer<HttpResponse> {
    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, HttpResponse httpResponse) {
        StringBuffer output = new StringBuffer();
        if (httpResponse != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("response()");
            if (httpResponse.getStatusCode() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withStatusCode(").append(httpResponse.getStatusCode()).append(")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 1, output, httpResponse.getHeaders());
            this.outputCookies(numberOfSpacesToIndent + 1, output, httpResponse.getCookies());
            if (httpResponse.getBodyAsString() != null && httpResponse.getBodyAsString().length() > 0) {
                if (httpResponse.getBody() instanceof BinaryBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    BinaryBody body = (BinaryBody)httpResponse.getBody();
                    output.append(".withBody(Base64Converter.base64StringToBytes(\"").append(Base64Converter.bytesToBase64String(body.getRawBytes())).append("\"))");
                } else {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withBody(\"").append(StringEscapeUtils.escapeJava((String)httpResponse.getBodyAsString())).append("\")");
                }
            }
            if (httpResponse.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serializeAsJava(0, httpResponse.getDelay())).append(")");
            }
            if (httpResponse.getConnectionOptions() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withConnectionOptions(");
                output.append(new ConnectionOptionsToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 2, httpResponse.getConnectionOptions()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
        }
        return output.toString();
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, List<Cookie> cookies) {
        if (cookies.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent + 1, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, List<Header> headers) {
        if (headers.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent + 1, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> StringBuffer appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        return output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

